﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using nspLable.Manage;
using Consultative;
using Base;
using SqlOperate;

public partial class Admin_Lable_Model_JobInfo : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                Bind();
            }
            else
                SystemLableTypeBind();
        }
    }

    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);
        txtLableName.Text = TSystem.Name.Substring(3);
        txtRemarks.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        dropDateClass.SelectedValue = TSystem.Info;
        txtContent.Value = TSystem.Content;
    }

    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TSystemLable TSystem = new TSystemLable();
            TSystem.Name = "SY_" + txtLableName.Text.Trim();
            TSystem.Remarks = txtRemarks.Text.Trim();
            TSystem.Title = "SY_JobInfo";
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
            TSystem.Info = dropDateClass.SelectedValue;
            TSystem.Content = txtContent.Value;
            ISystemLable RSystem = new RSystemLable();
            if (GetRequest.CheckQueryStringisInt("ID"))
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
        }
        catch (Exception ex)
        {
            Messagess.ShowMessage(ex.Message);
        }
    }
}
