﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using nspLable.Manage;
using Consultative;
using Base;
using SqlOperate;

public partial class Admin_Lable_Model_JobList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                BindJobType();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                BindJobType();
            }
        }
    }

    /// <summary>
    /// 绑定资讯类别
    /// </summary>
    private void BindJobType()
    {
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [C_JobType]");
        ddlBindType.DataSource = dt;
        ddlBindType.DataTextField = dt.Columns["TypeName"].ToString();
        ddlBindType.DataValueField = dt.Columns["ID"].ToString();
        ddlBindType.DataBind();
        ddlBindType.Items.Insert(0, new ListItem("--请选择--", "-1"));
    }

    /// <summary>
    /// 绑定求职标签列表
    /// </summary>
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);            //标签名称
        txtChineseName.Text = TSystem.Remarks;                      //备注
        dropLableType.SelectedValue = TSystem.TypeID.ToString();    //所属页面
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });
            ddlModelType.SelectedValue = str[0];                    //标签模板
            txtNum.Text = str[1];                                   //显示条数
            dropDateClass.SelectedValue = str[2];                   //日期格式
            if (str[3] == "1")                                      //属性
                cblAttribute.Checked = true;

            string[] typeName = str[4].Split(',');
            if (!(typeName[0].Equals("type")))                      //信息类型
                ddlNewsType.SelectedValue = typeName[0];
            else
            {
                ddlNewsType.SelectedValue = "type";
                ddlBindType.Style.Add("display", "inline");
                ddlBindType.SelectedValue = typeName[1];
            }
            ddlSort.SelectedValue = str[5];                         //排序方式
            rblIsPagination.SelectedValue = str[6];                 //是否分页
            if (rblIsPagination.SelectedValue == "1")
                PaginationStyle.Style.Add("display", "inline");
            txtThisPage.Text = str[7];                              //当前页样式
            txtOtherPage.Text = str[8];                            //其它页样式
        }
        LabelHead.Value = TSystem.Head;                             //标签头部
        txtContent.Value = TSystem.Content;                         //标签内容
        LabelFoot.Value = TSystem.Footer;                           //标签尾部
    }

    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    /// <summary>
    /// 插入或修改
    /// </summary>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TSystemLable TSystem = new TSystemLable();
            TSystem.Name = "SY_" + txtEngLishName.Text;
            TSystem.Remarks = txtChineseName.Text;
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
            TSystem.Title = "SY_JobList";
            StringBuilder stringStr = new StringBuilder();
            stringStr.Append(ddlModelType.SelectedValue + "|");     //标签模板
            stringStr.Append(txtNum.Text.Trim() + "|");             //显示条数 
            stringStr.Append(dropDateClass.SelectedValue + "|");    //日期格式
            if (cblAttribute.Checked == true)
                stringStr.Append("1|");
            else
                stringStr.Append("0|");
            if (!ddlNewsType.SelectedValue.Equals("type"))
                stringStr.Append(ddlNewsType.SelectedValue + "|");  //信息类型
            else
            {
                if (ddlBindType.SelectedValue != "-1")
                    stringStr.Append("type," + ddlBindType.SelectedValue + "|");
                else
                {
                    ShowMessage("必须选择一个类别!");
                    return;
                }
            }
            stringStr.Append(ddlSort.SelectedValue + "|");          //排序方式
            stringStr.Append(rblIsPagination.SelectedValue + "|");  //是否分页
            stringStr.Append(txtThisPage.Text.Trim() + "|");        //当前页样式
            stringStr.Append(txtOtherPage.Text.Trim());             //其他页样式
            TSystem.Info = stringStr.ToString();
            TSystem.Head = LabelHead.Value;                         //标签头部
            TSystem.Content = txtContent.Value;                     //标签内容
            TSystem.Footer = LabelFoot.Value;                       //标签尾部
            ISystemLable RSystem = new RSystemLable();
            if (GetRequest.CheckQueryStringisInt("ID"))
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
