﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;

public partial class Admin_Lable_Model_KnowProblemsList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtLableName.Text = TSystem.Name.Substring(3);
        txtRemarks.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                dropState.SelectedValue = str[0];
                txtRowsNum.Text = str[1];
                txtNum.Text = str[2];
                break;
            }
        }
        txtContent.Value = TSystem.Content;
        txtHead.Value = TSystem.Head;
        txtFooter.Value = TSystem.Footer;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtLableName.Text.Trim();
                TSystem.Remarks = txtRemarks.Text.Trim();
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "DIY_KnowProblemsList";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropState.SelectedValue + "|");      //问题状态
                stringStr.Append(txtRowsNum.Text + "|");              //问题标题长度
                stringStr.Append(txtNum.Text + "|");                  //显示信息条数
                string info = stringStr.ToString().TrimEnd(new char[] { '|' });
                TSystem.Info = info;

                TSystem.Content = txtContent.Value.Trim();
                TSystem.Head = txtHead.Value.Trim();
                TSystem.Footer = txtFooter.Value.Trim();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {
                ShowMessage("标签修改失败！");
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtLableName.Text.Trim();
                TSystem.Remarks = txtRemarks.Text.Trim();
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "DIY_KnowProblemsList";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropState.SelectedValue + "|");      //问题状态
                stringStr.Append(txtRowsNum.Text + "|");              //问题标题长度
                stringStr.Append(txtNum.Text + "|");                  //显示信息条数
                string info = stringStr.ToString().TrimEnd(new char[] { '|' });
                TSystem.Info = info;

                TSystem.Content = txtContent.Value.Trim();
                TSystem.Head = txtHead.Value.Trim();
                TSystem.Footer = txtFooter.Value.Trim();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {
                ShowMessage("标签修改失败！");
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
