﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using nspLable.Manage;
using Consultative;
using Base;
using SqlOperate;

public partial class Admin_Lable_Model_NewsList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {      
        if (!IsPostBack)
        {
            if (Request.QueryString["TypeID"] != "" && Request.QueryString["TypeID"] != null)
                BindNewsType(Request.QueryString["TypeID"]);
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                BindNewsType();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                BindNewsType();
            }
        }
    }

    public void BindNewsType(string TypeID)
    {
        string data = "";
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [W_ConsultativeType] WHERE [ParentID]=" + TypeID);
        if (dt.Rows.Count > 0)
        {
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                data += dt.Rows[i]["Name"].ToString() + "," + dt.Rows[i]["ID"].ToString() + ",";
            }
        }
        if (data != "")
            data = data.Remove(data.Length - 1);
        Response.Write(data);
    }

    /// <summary>
    /// 绑定资讯类别
    /// </summary>
    private void BindNewsType()
    {
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [W_ConsultativeType] WHERE [ParentID]=0");
        ddlBindType.DataSource = dt;
        ddlBindType.DataTextField = dt.Columns["Name"].ToString();
        ddlBindType.DataValueField = dt.Columns["ID"].ToString();
        ddlBindType.DataBind();
        ddlBindType.Items.Insert(0, new ListItem("--请选择--", "-1"));
    }

    /// <summary>
    /// 绑定资讯
    /// </summary>
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);            //标签名称
        txtChineseName.Text = TSystem.Remarks;                      //备注
        dropLableType.SelectedValue = TSystem.TypeID.ToString();    //所属页面
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });
            for (int k = 0; k < str.Length; k++)
            {
                switch (k)
                {
                    case 0: ddlModelType.SelectedValue = str[0]; break;    //标签模板
                    case 1: txtNum.Text = str[1]; break;                   //显示条数
                    case 2: txtTitleLength.Text = str[2]; break;           //标题长度
                    case 3: dropDateClass.SelectedValue = str[3]; break;   //日期格式
                    case 4:
                        string[] typeName = str[4].Split(',');
                        if (!(typeName[0].Equals("type")))                      //信息类型
                            ddlNewsType.SelectedValue = typeName[0];
                        else
                        {
                            ddlNewsType.SelectedValue = "type";
                            ddlBindType.Style.Add("display", "inline");
                            ddlBindType.SelectedValue = typeName[1];
                            if (typeName.Length == 3)
                            {
                                ddlSecondType.Style.Add("display", "inline");
                                DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [W_ConsultativeType] WHERE [ParentID]=" + typeName[1]);
                                ddlSecondType.DataSource = dt;
                                ddlSecondType.DataTextField = dt.Columns["Name"].ToString();
                                ddlSecondType.DataValueField = dt.Columns["ID"].ToString();
                                ddlSecondType.DataBind();
                                ddlSecondType.Items.Insert(0, new ListItem("--请选择--", "-1"));
                                ddlSecondType.SelectedValue = typeName[2];
                                dt.Dispose();
                                dt.Clear();
                            }
                        }
                        break;
                    case 5:
                        if (str[5] != "")                                       //文章属性
                        {
                            string[] lisNew = str[5].Split(new char[] { ',' });
                            for (int i = 0; i < lisNew.Length; i++)
                            {
                                if (lisNew[i].ToString() == "1")
                                    cblAttribute.Items[i].Selected = true;
                            }
                        }
                        break;
                    case 6: ddlSort.SelectedValue = str[6]; break;        //排序方式
                    case 7: rblIsPagination.SelectedValue = str[7]; break; //是否分页
                    case 8: txtThisPage.Text = str[8]; break;            //当前页样式
                    case 9: txtOtherPage.Text = str[9]; break;           //其它页样式
                    case 10: txtConterLength.Text = str[10]; break;
                }
            } 
        }
        LabelHead.Value = TSystem.Head;                             //标签头部
        txtContent.Value = TSystem.Content;                         //标签内容
        LabelFoot.Value = TSystem.Footer;                           //标签尾部
    }

    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    /// <summary>
    /// 插入或修改
    /// </summary>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            TSystemLable TSystem = new TSystemLable();
            TSystem.Name = "SY_" + txtEngLishName.Text;
            TSystem.Remarks = txtChineseName.Text;
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
            TSystem.Title = "SY_NewsList";
            StringBuilder stringStr = new StringBuilder();
            stringStr.Append(ddlModelType.SelectedValue + "|");     //标签模板
            stringStr.Append(txtNum.Text.Trim() + "|");             //显示条数 
            stringStr.Append(txtTitleLength.Text.Trim() + "|");     //标题长度
            stringStr.Append(dropDateClass.SelectedValue + "|");    //日期格式
            if (!ddlNewsType.SelectedValue.Equals("type"))
                stringStr.Append(ddlNewsType.SelectedValue + "|");  //信息类型
            else
            {
                string temp = "";
                if (ddlBindType.SelectedValue != "-1")
                {
                    temp = "type," + ddlBindType.SelectedValue;
                    if (Request.Form["ddlSecondType"] != null)
                    {
                        string k = Request.Form["ddlSecondType"].TrimEnd(new char[] { '\r', '\n' });
                        if (!k.Equals("-1"))
                            temp += "," + k;
                    }
                    stringStr.Append(temp + "|");  //信息类型
                }
                else
                    stringStr.Append("auto|");
            }
            foreach (ListItem li in cblAttribute.Items)
            {
                if (li.Selected)
                    myValue += "1,";
                else
                    myValue += "0,";
            }
            if (myValue != "")
            {
                myValue = myValue.Substring(0, myValue.Length - 1);
            }
            stringStr.Append(myValue + "|");                        //文章属性
            stringStr.Append(ddlSort.SelectedValue + "|");          //排序方式
            stringStr.Append(rblIsPagination.SelectedValue + "|");  //是否分页
            if (rblIsPagination.SelectedValue == "1")
                PaginationStyle.Style.Add("display", "inline");
            stringStr.Append(txtThisPage.Text.Trim() + "|");        //当前页样式
            stringStr.Append(txtOtherPage.Text.Trim() + "|");       //其他页样式
            stringStr.Append(txtConterLength.Text.Trim()+"|");
            TSystem.Info = stringStr.ToString();
            TSystem.Head = LabelHead.Value;                         //标签头部
            TSystem.Content = txtContent.Value;                     //标签内容
            TSystem.Footer = LabelFoot.Value;                       //标签尾部
            ISystemLable RSystem = new RSystemLable();
            if (GetRequest.CheckQueryStringisInt("ID"))
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
