﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using nspLable.Manage;
using Consultative;
using Base;


public partial class admin_Lable_Model_NewsList_Str : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                ConsultativeTypeBind();
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                ConsultativeTypeBind();
                SystemLableTypeBind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });
            txtNum.Text = str[0];
            txtRowsNum.Text = str[1];
            radlisType.SelectedValue = str[2];
            txtTitleLenght.Text = str[3];
            txtTitleClass.Text = str[4];
            dropTarget.SelectedValue = str[5];
            dropisDate.SelectedValue = str[6];
            dropDateClass.SelectedValue = str[7];
            dropConsultativeType.SelectedValue = str[8];
            if (str[9] != "")
            {
                string[] lisNew = str[9].Split(new char[] { ',' });
                for (int j = 0; j < lisNew.Length; j++)
                {
                    if (lisNew[j].ToString() == "1")
                        chkAttribute.Items[j].Selected = true;
                }
            }
            this.txtTitleSpace.Text = str[10];
        }
    }

    /// <summary>
    /// 绑定资讯类别
    /// </summary>
    private void ConsultativeTypeBind()
    {
        IConsultativeType RCon = new RConsultativeType();
        DataTable dt = RCon.GetDataTable();
        dropConsultativeType.DataSource = dt.DefaultView;
        dropConsultativeType.DataValueField = "ID";
        dropConsultativeType.DataTextField = "Name";
        dropConsultativeType.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropConsultativeType.Items.Add(li);
		ListItem ll = new ListItem("随机", "-1");
		dropConsultativeType.Items.Add(ll);
        li.Selected = true;
    }

    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            TSystemLable TSystem = new TSystemLable();
            TSystem.Name = "SY_" + txtEngLishName.Text;
            TSystem.Remarks = txtChineseName.Text;
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
            TSystem.Title = "SY_NewsList_Str";
            StringBuilder stringStr = new StringBuilder();
            stringStr.Append(txtNum.Text + "|");                    //显示条数
            stringStr.Append(txtRowsNum.Text + "|");                //每行显示几条
            stringStr.Append(radlisType.SelectedValue + "|");       //是否显示类型
            stringStr.Append(txtTitleLenght.Text + "|");            //显示标题字数
            stringStr.Append(txtTitleClass.Text + "|");             //标题样式
            stringStr.Append(dropTarget.SelectedValue + "|");       //链接目标
            stringStr.Append(dropisDate.SelectedValue + "|");       //是否显示日期
            stringStr.Append(dropDateClass.SelectedValue+ "|");     //日期格式
            stringStr.Append(dropConsultativeType.SelectedValue + "|");       //信息类别，0为全部
            foreach (ListItem li in chkAttribute.Items)                 //显示内容
            {
                if (li.Selected)
                {
                    myValue += "1,";
                }
                else
                {
                    myValue += "0,";
                }

            }
            if (myValue != "")
            {
                myValue = myValue.Substring(0, myValue.Length - 1);
            }
            stringStr.Append(myValue);
            stringStr.Append("|"+txtTitleSpace.Text  );
            TSystem.Info = stringStr.ToString();
            ISystemLable RSystem = new RSystemLable();

            if (Request.QueryString["ID"] != null)
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }           
    }



    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>"); 
    }
}
