﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using nspLable.Manage;
using Consultative;
using Base;
using SqlOperate;


public partial class Admin_Lable_Model_NewsTypeList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                BindTypeModel();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                BindTypeModel();
            }
        }
    }

    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);
        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });
            ddlTypeModel.SelectedValue = str[0];
            txtNum.Text = str[1];
        }
        LabelHead.Value = TSystem.Head;
        txtContent.Value = TSystem.Content;
        LabelFoot.Value = TSystem.Footer;
    }

    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    private void BindTypeModel()
    {
        DataTable dt = SqlHelper.ExecuteSqlQuery("SELECT * FROM [W_ConsultativeType] WHERE [ParentID]=0");
        ddlTypeModel.DataSource = dt;
        ddlTypeModel.DataTextField = dt.Columns["Name"].ToString();
        ddlTypeModel.DataValueField = dt.Columns["ID"].ToString();
        ddlTypeModel.DataBind();
        ddlTypeModel.Items.Insert(0, new ListItem("自动绑定", "auto"));
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TSystemLable TSystem = new TSystemLable();
            TSystem.Name = "SY_" + txtEngLishName.Text.Trim();
            TSystem.Remarks = txtChineseName.Text.Trim();
            TSystem.Title = "SY_NewsTypeList";
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
            StringBuilder stringStr = new StringBuilder();
            stringStr.Append(ddlTypeModel.SelectedValue + "|");     //所属分类
            stringStr.Append(txtNum.Text.Trim());             //显示条数 
            TSystem.Info = stringStr.ToString();
            TSystem.Head = LabelHead.Value.Trim();
            TSystem.Content = txtContent.Value;
            TSystem.Footer = LabelFoot.Value.Trim();
            ISystemLable RSystem = new RSystemLable();
            if (GetRequest.CheckQueryStringisInt("ID"))
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
        }
        catch (Exception ex)
        {
            Messagess.ShowMessage(ex.Message);
        }
    }
}
