﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using nspLable.Manage;
using Consultative;
using Base;

public partial class admin_Lable_Model_Newslist_pic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

               
                ConsultativeTypeBind();
                SystemLableTypeBind(); 
                Bind();
            }
            else
            {
                ConsultativeTypeBind();
                SystemLableTypeBind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem=RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        { 
            string[] str=TSystem.Info.Split(new char[]{'|'});
           
            int i=0;
            while(i<str.Length)
            {
                dropwhichtype.SelectedValue = str[0];
                txtpicWidth.Text = str[1];
                txtpicHeight.Text = str[2];
                txtpicBorder.Text = str[3];
                dropistitle.SelectedValue = str[4];
                txtClass.Text = str[5];
                txtTitleSize.Text = str[6];
                txtContentSize.Text = str[7];
                dropTarget.SelectedValue = str[8];
                txtNum.Text = str[9];
                txtRowsNum.Text = str[10];
                dropTypeID.SelectedValue = str[11];
                if (str[12] !="")
                {
                    string[] lisNew = str[12].Split(new char[] { ',' });
                    for (int j = 0; j < lisNew.Length; j++)
                    {
                        if(lisNew[j].ToString()=="1")
                            chklisNew.Items[j].Selected = true;
                    }
                }
                break;
            }
        }
    }
    private void ConsultativeTypeBind()
    {
        IConsultativeType RCon = new RConsultativeType();
        DataTable dt=RCon.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataTextField = "Name";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部","0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt=RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null)
        {
            try
            {
                string myValue = "";
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_NewsList_Pic";
          
                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropwhichtype.SelectedValue + "|");   //列表样式 
                stringStr.Append(txtpicWidth.Text + "|");              //图片宽度
                stringStr.Append(txtpicHeight.Text + "|");             //图片高度
                stringStr.Append(txtpicBorder.Text + "|");             //图片边框
                stringStr.Append(dropistitle.SelectedValue + "|");     //是否显示标题
                stringStr.Append(txtClass.Text + "|");                 //标题样式
                stringStr.Append(txtTitleSize.Text + "|");             //显示标题字数
                stringStr.Append(txtContentSize.Text + "|");           //显示内容字数
                stringStr.Append(dropTarget.SelectedValue + "|");      //链接目标
                stringStr.Append(txtNum.Text + "|");                   //显示条数
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示几条
                stringStr.Append(dropTypeID.SelectedValue + "|");      //资讯类别

                foreach (ListItem li in chklisNew.Items)
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue);
                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                Messagess.ShowMessage(ex.Message);
            }

        }
        else
        {
            try
            {
                string myValue = "";
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_NewsList_Pic";
              
                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(dropwhichtype.SelectedValue + "|");   //列表样式 
                stringStr.Append(txtpicWidth.Text + "|");              //图片宽度
                stringStr.Append(txtpicHeight.Text + "|");             //图片高度
                stringStr.Append(txtpicBorder.Text + "|");             //图片边框
                stringStr.Append(dropistitle.SelectedValue + "|");     //是否显示标题
                stringStr.Append(txtClass.Text + "|");                 //标题样式
                stringStr.Append(txtTitleSize.Text + "|");             //显示标题字数
                stringStr.Append(txtContentSize.Text + "|");           //显示内容字数
                stringStr.Append(dropTarget.SelectedValue + "|");      //链接目标
                stringStr.Append(txtNum.Text + "|");                   //显示条数
                stringStr.Append(txtRowsNum.Text + "|");               //每行显示几条
                stringStr.Append(dropTypeID.SelectedValue + "|");      //资讯类别

                foreach (ListItem li in chklisNew.Items)
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue);
                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                Messagess.ShowMessage(ex.Message);
            }
        }
    }


    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>"); 
    }
}
