﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using Base;

public partial class Admin_Lable_Model_ProductInfo : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);
        txtLableName.Text = TSystem.Name.Substring(3);
        txtRemarks.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        txtContent.Value = TSystem.Content;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }

    /// <summary>
    /// 修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TSystemLable TSystem = new TSystemLable();

            TSystem.Name = "SY_" + txtLableName.Text;
            TSystem.Remarks = txtRemarks.Text;
            TSystem.Title = "DIY_ProductInfo";
            TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
            //TSystem.Head = txtHead.Text;
            TSystem.Content = txtContent.Value;
            // TSystem.Footer = txtFooter.Text;
            ISystemLable RSystem = new RSystemLable();

            if (Request.QueryString["ID"] != null)
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystem.ID = id;
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
            }
            else
            {
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
            }
            Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
        }
        catch (Exception ex)
        {

            ShowMessage(ex.Message);
        }
    }

    /// <summary>
    /// 取消
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
