﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;
using Product;

public partial class admin_Lable_Model_ProductList_Pic : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                IndustryTypeBind();
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                IndustryTypeBind();
                SystemLableTypeBind();
            }
        }

    }

    /// <summary>
    /// 行业类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void IndustryTypeBind()
    {
        IIndustryType IInd = new RIndustryType();
        DataTable dt = IInd.GetDataTable(0);
        dropIndType.DataSource = dt.DefaultView;
        dropIndType.DataValueField = "ID";
        dropIndType.DataTextField = "Type";
        dropIndType.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropIndType.Items.Add(li);
        li.Selected = true;
    }
    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                txtNum.Text = str[0];
                txtRowsNum.Text = str[1];
                radlProAttribute.SelectedValue = str[2];
                dropWhitchType.SelectedValue = str[3];
                dropTypeID.SelectedValue = str[4];
                dropIndType.SelectedValue = str[5];
                dropOrderBy.SelectedValue = str[6];
                txtPicHeight.Text = str[7];
                txtPicWidth.Text = str[8];
                txtPicClass.Text = str[9];
                txtTitleSize.Text = str[10];
                txtTitleClass.Text = str[11];
                dropTarget.SelectedValue = str[12];
                break;
            }
            if (dropWhitchType.SelectedValue == "1")
            {
                trTitleSize.Visible = true;
                trTitleClass.Visible = true;
            }
            else
            {
                trTitleSize.Visible = false;
                trTitleClass.Visible = false;
            }
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        
        if (Request.QueryString["ID"] != null)
        {
            try
            {

                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();

                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Productlist_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text.Trim() + "|");                    //信息列表数目
                stringStr.Append(txtRowsNum.Text.Trim() + "|");                //每行显示几条
                stringStr.Append(radlProAttribute.SelectedValue + "|");        //信息列表属性
                stringStr.Append(dropWhitchType.SelectedValue.Trim() + "|");   //列表显示样式
                stringStr.Append(dropTypeID.SelectedValue.Trim() + "|");       //信息类型
                stringStr.Append(dropIndType.SelectedValue.Trim() + "|");      //行业类别
                stringStr.Append(dropOrderBy.SelectedValue.Trim() + "|");      //排序方式(0：ID升序；1：ID降序；2：时间升序；3：时间降序[默认])
                stringStr.Append(txtPicHeight.Text.Trim() + "|");              //图片高度
                stringStr.Append(txtPicWidth.Text.Trim() + "|");               //图片宽度
                stringStr.Append(txtPicClass.Text.Trim() + "|");               //图片样式
                stringStr.Append(txtTitleSize.Text.Trim()+ "|");               //标题最多字符数
                stringStr.Append(txtTitleClass.Text.Trim() + "|");             //标题样式
                stringStr.Append(dropTarget.SelectedValue.Trim());             //打开方式

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {

                TSystemLable TSystem = new TSystemLable();

                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Productlist_Pic";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text.Trim() + "|");                    //信息列表数目
                stringStr.Append(txtRowsNum.Text.Trim() + "|");                //每行显示几条
                stringStr.Append(radlProAttribute.SelectedValue + "|"); //信息列表属性
                stringStr.Append(dropWhitchType.SelectedValue.Trim() + "|");   //列表显示样式
                stringStr.Append(dropTypeID.SelectedValue.Trim() + "|");       //信息类型
                stringStr.Append(dropIndType.SelectedValue.Trim() + "|");      //行业类别
                stringStr.Append(dropOrderBy.SelectedValue.Trim() + "|");      //排序方式(0：ID升序；1：ID降序；2：时间升序；3：时间降序[默认])
                stringStr.Append(txtPicHeight.Text.Trim() + "|");              //图片高度
                stringStr.Append(txtPicWidth.Text.Trim() + "|");               //图片宽度
                stringStr.Append(txtPicClass.Text.Trim() + "|");               //图片样式
                stringStr.Append(txtTitleSize.Text.Trim() + "|");              //标题最多字符数
                stringStr.Append(txtTitleClass.Text.Trim() + "|");             //标题样式
                stringStr.Append(dropTarget.SelectedValue.Trim());             //打开方式

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");
    }

    protected void dropWhitchType_SelectedIndexChanged(object sender, EventArgs e)
    {

        if (dropWhitchType.SelectedValue == "1")
        {
            trTitleSize.Visible = true;
            trTitleClass.Visible = true;
        }
        else
        {
            trTitleSize.Visible = false;
            trTitleClass.Visible = false;
        }
    }
}
