﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;
using Product;


public partial class admin_Lable_Model_Productlist_Str : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {
                IndustryTypeBind();
                SystemLableTypeBind();
                Bind();
            }
            else
            {
                IndustryTypeBind();
                SystemLableTypeBind();
            }
        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                txtNum.Text = str[0];
                txtRowsNum.Text = str[1];
                dropTypeID.SelectedValue = str[2];
                dropIndType.SelectedValue = str[3];
                radlProAttribute.SelectedValue = str[4];
                dropOrderBy.SelectedValue = str[5];
                txtTitleSize.Text = str[6];
                txtTitleClass.Text = str[7];
                if (str[8] != "")
                {
                    string[] lisNew = str[8].Split(new char[] { ',' });
                    for (int j = 0; j < lisNew.Length; j++)
                    {
                        if (lisNew[j].ToString()=="1")
                            chklisShow.Items[j].Selected = true;
                    }
                }
                dropTarget.SelectedValue = str[9];
                break;
            }
        }
    }
    /// <summary>
    /// 行业类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void IndustryTypeBind()
    {
        IIndustryType IInd = new RIndustryType();
        DataTable dt = IInd.GetDataTable(0);
        dropIndType.DataSource = dt.DefaultView;
        dropIndType.DataValueField = "ID";
        dropIndType.DataTextField = "Type";
        dropIndType.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropIndType.Items.Add(li);
        li.Selected = true;
    }
    /// <summary>
    /// 绑定系统标签类别
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
       if (Request.QueryString["ID"] != null)
        {
            try
            {
                
                string myValue = "";
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Productlist_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text + "|");                    //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                //每行显示几条
                stringStr.Append(dropTypeID.SelectedValue + "|");       //信息类型
                stringStr.Append(dropIndType.SelectedValue + "|");      //行业类别
                stringStr.Append(radlProAttribute.SelectedValue + "|"); //信息列表属性
                stringStr.Append(dropOrderBy.SelectedValue + "|");      //排序方式
                stringStr.Append(txtTitleSize.Text + "|");              //标题最多字符数
                stringStr.Append(txtTitleClass.Text + "|");             //CSS类名

                foreach (ListItem li in chklisShow.Items)                 //显示内容
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue + "|");
                stringStr.Append(dropTarget.SelectedValue);        //打开方式 

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                ShowMessage("标签修改成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
                string myValue = "";
                TSystemLable TSystem = new TSystemLable();

                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_Productlist_Str";

                StringBuilder stringStr = new StringBuilder();
                stringStr.Append(txtNum.Text + "|");                    //信息列表数目
                stringStr.Append(txtRowsNum.Text + "|");                //每行显示几条
                stringStr.Append(dropTypeID.SelectedValue + "|");       //信息类型
                stringStr.Append(dropIndType.SelectedValue + "|");      //行业类别
                stringStr.Append(radlProAttribute.SelectedValue + "|"); //信息列表属性
                stringStr.Append(dropOrderBy.SelectedValue + "|");      //排序方式
                stringStr.Append(txtTitleSize.Text + "|");              //标题最多字符数
                stringStr.Append(txtTitleClass.Text + "|");             //CSS类名

                foreach (ListItem li in chklisShow.Items)                 //显示内容
                {
                    if (li.Selected)
                    {
                        myValue += "1,";
                    }
                    else
                    {
                        myValue += "0,";
                    }

                }
                if (myValue != "")
                {
                    myValue = myValue.Substring(0, myValue.Length - 1);
                }
                stringStr.Append(myValue + "|");
                stringStr.Append(dropTarget.SelectedValue);        //打开方式 

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                ShowMessage("标签添加成功！");

                Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");

            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href = '../SystemLable/SystemLableManage.aspx' </script>");
    }
}
