﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspLable.Manage;
using System.Text;
using Consultative;

public partial class admin_Lable_Model_RelatedNews : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            if (Request.QueryString["ID"] != null)
            {

                SystemLableTypeBind();
                ConsultativeTypeBind();
                Bind();
            }
            else
            {
                SystemLableTypeBind();
                ConsultativeTypeBind();
            }

        }
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        ISystemLable RSystem = new RSystemLable();
        TSystemLable TSystem = RSystem.GateItem(id);

        txtEngLishName.Text = TSystem.Name.Substring(3);
        txtChineseName.Text = TSystem.Remarks;
        dropLableType.SelectedValue = TSystem.TypeID.ToString();
        if (TSystem.Info != null)
        {
            string[] str = TSystem.Info.Split(new char[] { '|' });

            int i = 0;
            while (i < str.Length)
            {
                txtNum.Text = str[0];
                txtRowsNum.Text = str[1];
                dropTypeID.SelectedValue = str[2];
                dropShowType.SelectedValue = str[3];
                txtTypeSize.Text = str[4];
                txtTypeClass.Text = str[5];
                txtTitleSize.Text = str[6];
                txtTitleClass.Text = str[7];
                radlShowDate.SelectedValue = str[8];
                dropDateClass.SelectedValue = str[9];
                dropTarget.SelectedValue = str[10];
                break;
            }
        }
    }
    /// <summary>
    /// 资讯类别 
    /// </summary>
    private void ConsultativeTypeBind()
    {
        IConsultativeType RCon = new RConsultativeType();
        DataTable dt = RCon.GetDataTable();
        dropTypeID.DataSource = dt.DefaultView;
        dropTypeID.DataTextField = "Name";
        dropTypeID.DataValueField = "ID";
        dropTypeID.DataBind();
        ListItem li = new ListItem("全部", "0");
        dropTypeID.Items.Add(li);
        li.Selected = true;
    }
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(0);
        dropLableType.DataSource = dt.DefaultView;
        dropLableType.DataValueField = "ID";
        dropLableType.DataTextField = "Name";
        dropLableType.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {

        if (Request.QueryString["ID"] != null)
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                TSystemLable TSystem = new TSystemLable();
                TSystem.ID = id;
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_RelatedNews";

                StringBuilder stringStr = new StringBuilder();
                if (Base.Common.CheckNum(txtNum.Text))
                    stringStr.Append(txtNum.Text + "|");                    //显示条数
                else
                    stringStr.Append("0|");
                if (Base.Common.CheckNum(txtRowsNum.Text))                  //每行显示条数
                    stringStr.Append(txtRowsNum.Text + "|");
                else
                    stringStr.Append("0|");
                stringStr.Append(dropTypeID.SelectedValue + "|");           //资讯类别
                stringStr.Append(dropShowType.SelectedValue + "|");         //是否显示资讯类别
                if (Base.Common.CheckNum(txtTypeSize.Text))                 //类别字数
                    stringStr.Append(txtTypeSize.Text + "|");
                else
                    stringStr.Append("0|");
                stringStr.Append(txtTypeClass.Text + "|");                  //类别样式

                if (Base.Common.CheckNum(txtTitleSize.Text))                //标题字数
                    stringStr.Append(txtTitleSize.Text + "|");
                else
                    stringStr.Append("0|");
                stringStr.Append(txtTitleClass.Text + "|");                 //标题样式
                stringStr.Append(radlShowDate.SelectedValue + "|");         //是否显示日期
                stringStr.Append(dropDateClass.SelectedValue + "|");        //日期样式
                stringStr.Append(dropTarget.SelectedValue + "|");           //链接目标


                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Update(TSystem);
                Messagess.ShowMessage("标签修改成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
        else
        {
            try
            {
                TSystemLable TSystem = new TSystemLable();
                TSystem.Name = "SY_" + txtEngLishName.Text;
                TSystem.Remarks = txtChineseName.Text;
                TSystem.TypeID = int.Parse(dropLableType.SelectedValue);
                TSystem.Title = "SY_RelatedNews";

                StringBuilder stringStr = new StringBuilder();
                if (Base.Common.CheckNum(txtNum.Text))
                    stringStr.Append(txtNum.Text + "|");                    //显示条数
                else
                    stringStr.Append("0|");
                if (Base.Common.CheckNum(txtRowsNum.Text))                  //每行显示条数
                    stringStr.Append(txtRowsNum.Text + "|");
                else
                    stringStr.Append("0|");
                stringStr.Append(dropTypeID.SelectedValue + "|");           //资讯类别
                stringStr.Append(dropShowType.SelectedValue + "|");         //是否显示资讯类别
                if (Base.Common.CheckNum(txtTypeSize.Text))                 //类别字数
                    stringStr.Append(txtTypeSize.Text + "|");
                else
                    stringStr.Append("0|");
                stringStr.Append(txtTypeClass.Text + "|");                  //类别样式

                if (Base.Common.CheckNum(txtTitleSize.Text))                //标题字数
                    stringStr.Append(txtTitleSize.Text + "|");
                else
                    stringStr.Append("0|");
                stringStr.Append(txtTitleClass.Text + "|");                 //标题样式
                stringStr.Append(radlShowDate.SelectedValue + "|");         //是否显示日期
                stringStr.Append(dropDateClass.SelectedValue + "|");        //日期样式
                stringStr.Append(dropTarget.SelectedValue + "|");           //链接目标

                TSystem.Info = stringStr.ToString();
                ISystemLable RSystem = new RSystemLable();
                RSystem.Insert(TSystem);
                Messagess.ShowMessage("标签添加成功！");
                Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
            }
            catch (Exception ex)
            {

                ShowMessage(ex.Message);
            }
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script>window.parent.window.location.href='../SystemLable/SystemLableManage.aspx'</script>");
    }
}
