﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using Base;
public partial class admin_Lable_SystemLable_SystemLableManage : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!this.IsPostBack)
        {
            LableTypeBind();
            Bind();
        }
    }


    /// <summary>
    /// 标签类别绑定
    /// </summary>
    private void LableTypeBind()
    {
        dropLableType.Items.Add(new ListItem("--+所有类别+--", ""));
        ISystemLableType RSys = new RSystemLableType();
        DataTable dt = RSys.GetDataTable();
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropLableType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
    }


    /// <summary>
    /// 数据绑定
    /// </summary>
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "return confirm('你确认要删除吗？')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_SystemLable as a left join W_SystemLableType as b on a.TypeID=b.ID";
        PageNo1.FldName = "a.ID";
        PageNo1.StrGetFields = "a.ID,a.TypeID,a.Name,a.Info,a.Remarks,a.Head,a.Content,a.Footer,b.Name as TypeName";
        PageNo1.PageSize = 12;
        string labletype = "";
        string strWhere = "1=1";
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"]);
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdSystemlable.DataSource = dt.DefaultView;
            grdSystemlable.DataBind();
        }
        else {
            if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
            {
                labletype = Request.QueryString["TypeID"].ToString();
                strWhere += " and a.TypeID=" + labletype;
            }
            else
            {
                string TitleName = Base.GetRequest.Filter(txtTitleName.Text.Trim());
                labletype = dropLableType.SelectedValue;
                if (TitleName != "")
                    strWhere += " and a.Name like '%" + TitleName + "%'";
                if (labletype != "")
                    strWhere += " and a.TypeID=" + labletype;
            }
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdSystemlable.DataSource = dt.DefaultView;
            grdSystemlable.DataBind();
        }       
    }
    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdSystemlable.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSystemlable.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdSystemlable.DataKeys[i].Value);
                ISystemLable RSystem = new RSystemLable();
                int m = RSystem.Delete(id);
            }
        }
        Bind();
    }


    /// <summary>
    /// 删除单条记录 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void grdSystemlable_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdSystemlable.DataKeys[e.RowIndex].Value.ToString());
        ISystemLable RSystem = new RSystemLable();
        int m = RSystem.Delete(id);
        Bind();
    }


    /// <summary>
    /// 系统标签搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        string TitleName = Base.GetRequest.Filter(txtTitleName.Text.Trim());
        string labletype = dropLableType.SelectedValue;
        if (TitleName != "")
            strWhere += " and a.Name like '%" + Base.GetRequest.Filter(TitleName) + "%'";
        if (labletype != "")
            strWhere += " and a.TypeID=" + labletype;

        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl);
        Response.End();
    }
    protected void grdSystemlable_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}
