﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using Base;

public partial class admin_Lable_SystemLableType_SystemLableManage : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        int ParentId = 0;
        string name = "";
        if (Request.QueryString["ParentID"] != null)
        {
            ParentId = int.Parse(Request.QueryString["ParentID"].ToString());
        }
        //if (Request.QueryString["Name"] != null && Request.QueryString["Name"] != "")
        //{
        //    name = Request.QueryString["Name"].ToString();
        //    lblName.Text = name;
        //}
        //else
        //    lblName.Text = "一级类别";
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt = RSystem.GetDataTable(ParentId);
        if (dt.DefaultView.Count == 0)
        {
            lblMessage.Visible = true;
            lblMessage.Text = "没有相关记录";
        }
        else
            lblMessage.Visible = false;
        dlstSystemLableType.DataSource = dt.DefaultView;
        dlstSystemLableType.DataBind();

    }
    /// <summary>
    /// 添加类别
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int ParentID = 0;
            string Restr = "";
            if (Request.QueryString["ParentID"] != null && Request.QueryString["ParentID"] != "")
            {
                ParentID = int.Parse(Request.QueryString["ParentID"]);
            }
            TSystemLableType TSystem = new TSystemLableType();
            if (txtLableType.Text.Equals(string.Empty))
                Restr = "标签类别";
            else
                TSystem.Name = txtLableType.Text;
            TSystem.ParentID = ParentID;
            ISystemLableType RSystem = new RSystemLableType();
            if (Restr == "")
            {
                RSystem.Insert(TSystem);
                ShowMessage("标签类别添加成功！", "Lable/SystemLableType/SystemLableTypeManage.aspx?ParentID=" + ParentID);
                lblMessage.Visible = false;
            }
            else {
                lblMessage.Visible = true;
                lblMessage.Text = Restr+"输入有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage("标签类别添加失败！", "Lable/SystemLableType/SystemLableTypeManage.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        pnlLableType.Visible = false;
    }
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        //int ParentID = 0;
        //string name="";
        //if (Request.QueryString["ParentID"] != null)
        //{
        //    ParentID = int.Parse(Request.QueryString["ParentID"].ToString());
        //}
        //if (Request.QueryString["Name"] != null)
        //{
        //    name = Request.QueryString["Name"].ToString();
        //}
        //Response.Redirect("SystemLableTypeAdd.aspx?ParentID=" + ParentID + "&Name=" + name);
        if (pnlLableType.Visible)
            pnlLableType.Visible = false;
        else
            pnlLableType.Visible = true;

    }
    protected void dlstSystemLableType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstSystemLableType.EditItemIndex = -1;
        Bind();
    }
    protected void dlstSystemLableType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstSystemLableType.DataKeys[e.Item.ItemIndex]);
        ISystemLableType RSystem = new RSystemLableType();
        RSystem.Delete(id);
        Bind();
    }
    protected void dlstSystemLableType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstSystemLableType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }
    protected void dlstSystemLableType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstSystemLableType.DataKeys[e.Item.ItemIndex]);
        string name = ((TextBox)e.Item.FindControl("txtName")).Text;
        TSystemLableType TSystem = new TSystemLableType();
        TSystem.ID = id;
        TSystem.Name = name;
        ISystemLableType RSystem = new RSystemLableType();
        RSystem.Update(TSystem);
        dlstSystemLableType.EditItemIndex = -1;
        Bind();
    }
}
