﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using nspBase;
using Base;

public partial class admin_Lable_UserLable_UserLableAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        IUserLableType RUser = new RUserLableType();
        DataTable dt = RUser.GetDataTable();
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropLableType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
        else
            dropLableType.Items.Add(new ListItem("--+暂无分类+--", "0"));

    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            TUserLable TUser = new TUserLable();
            TUser.LableName = "WS_" + this.txtLableName.Text;
            TUser.Info = this.txtInfo.Text;
            TUser.Remarks = this.txtRemarks.Text;
            TUser.TypeID = int.Parse(dropLableType.SelectedValue);
            IUserLable RUser = new RUserLable();
            RUser.Insert(TUser);
            ShowMessage("添加{WS_" + txtLableName.Text + "}成功！", "Lable/UserLable/UserLableManage.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("添加{WS_" + txtLableName.Text + "}失败！", "Lable/UserLable/UserLableManage.aspx");
        }
    }
}
