﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using Base;

public partial class admin_Lable_UserLable_UserLableEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            LableTypeBind();
            Bind();
        }
    }
    /// <summary>
    /// 标签类别绑定
    /// </summary>
    private void LableTypeBind()
    {

        IUserLableType RUser = new RUserLableType();
        DataTable dt = RUser.GetDataTable();
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropLableType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
        else
            dropLableType.Items.Add(new ListItem("--+暂无分类+--", "0"));
    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"]);
        IUserLable RUser = new RUserLable();
        TUserLable TUser = RUser.GateItem(id);
        txtLableName.Text = TUser.LableName.Substring(3);
        txtInfo.Text = TUser.Info;
        txtRemarks.Text = TUser.Remarks;
        dropLableType.SelectedValue = TUser.TypeID.ToString();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int id = int.Parse(Request.QueryString["ID"]);
            TUserLable TUser = new TUserLable();
            TUser.ID = id;
            TUser.LableName = "WS_" + txtLableName.Text;
            TUser.Info = txtInfo.Text;
            TUser.Remarks = txtRemarks.Text;
            TUser.TypeID = int.Parse(dropLableType.SelectedValue);
            IUserLable RUser = new RUserLable();
            RUser.Update(TUser);
            ShowMessage("修改成功！", "Lable/UserLable/UserLableManage.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("修改失败！", "Lable/UserLable/UserLableManage.aspx");
        }
    }
}
