﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using Base;

public partial class admin_Lable_UserLable_UserLableManage : BasePage
{   
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            LableTypeBind();
            Bind();
        }
    }
    /// <summary>
    /// 标签类别绑定
    /// </summary>
    private void LableTypeBind()
    {
        dropLableType.Items.Add(new ListItem("--+所有类别+--", ""));
        IUserLableType RUser = new RUserLableType();
        DataTable dt = RUser.GetDataTable();
        if (dt.Rows.Count != 0)
        {
            foreach (DataRow dataRow in dt.Rows)
            {
                dropLableType.Items.Add(new ListItem(dataRow["Name"].ToString(), dataRow["ID"].ToString()));
            }
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确定删除吗？一旦删除后，调用它的页面将出错！请慎重操作！')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_UserLable as a left join W_UserLableType as b on a.TypeID=b.ID";
        PageNo1.FldName = "a.AddDate";
        PageNo1.StrGetFields = "a.ID,a.TypeID,a.LableName,a.AddDate,a.Info,a.Remarks,b.Name as TypeName";
        PageNo1.PageSize = 12;
        string labletype = "";
        string strWhere = "1=1";
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdUserLable.DataSource = dt.DefaultView;
            grdUserLable.DataBind();
        }
        else {
            if (Request.QueryString["TypeID"] != null && Request.QueryString["TypeID"] != "")
            {
                labletype = Request.QueryString["TypeID"].ToString();
                strWhere += " and a.TypeID=" + labletype;
            }
            else
            {
                string TitleName = Base.GetRequest.Filter(txtTitleName.Text.Trim());
                labletype = dropLableType.SelectedValue;
                if (TitleName != "")
                    strWhere += " and a.LableName like '%" + TitleName + "%'";
                if (labletype != "")
                    strWhere += " and a.TypeID=" + labletype;
            }
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            grdUserLable.DataSource = dt.DefaultView;
            grdUserLable.DataBind();
        }
    }
    /// <summary>
    /// 用户标签搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "1=1";
        string TitleName = txtTitleName.Text.Trim();
        string labletype = dropLableType.SelectedValue;
        if (TitleName != "")
            strWhere += " and a.LableName like '%" + Base.GetRequest.Filter(TitleName) + "%'";
        if (labletype != "")
            strWhere += " and a.TypeID=" + labletype;

        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl);
        Response.End();
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != "")
        {
            return Convert.ToDateTime(dateStr).ToShortDateString();
        }
        else
            return string.Empty;
    }
    protected void grdUserLable_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(grdUserLable.DataKeys[e.RowIndex].Value);
        IUserLable RUser = new RUserLable();
        RUser.Delete(id);
        Bind();
    }

    /// <summary>
    /// 批量删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdUserLable.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdUserLable.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int id = Convert.ToInt32(grdUserLable.DataKeys[i].Value);
                IUserLable RUser = new RUserLable();
                int m = RUser.Delete(id);
            }
        }
        Bind();
    }
    protected void grdUserLable_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }
}
