﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspLable.Manage;
using Base;

public partial class admin_Lable_UserLableType_UserLableManage : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        IUserLableType RUser = new RUserLableType();
        DataTable dt = RUser.GetDataTable();
        dlstUserLableType.DataSource = dt.DefaultView;
        dlstUserLableType.DataBind();
    }
    protected void dlstUserLableType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstUserLableType.EditItemIndex = -1;
        Bind();
    }
    protected void dlstUserLableType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstUserLableType.DataKeys[e.Item.ItemIndex]);
        IUserLableType RUser = new RUserLableType();
        RUser.Delete(id);
        Bind();
    }
    protected void dlstUserLableType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstUserLableType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }
    protected void dlstUserLableType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstUserLableType.DataKeys[e.Item.ItemIndex]);
        string name=((TextBox)e.Item.FindControl("txtName")).Text;
        TUserLableType TUser = new TUserLableType();
        TUser.ID = id;
        TUser.Name = name;
        IUserLableType RUser = new RUserLableType();
        RUser.Update(TUser);
        dlstUserLableType.EditItemIndex = -1;
        Bind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        TUserLableType TUser = new TUserLableType();
        IUserLableType Ruser = new RUserLableType();
        try
        {
            TUser.Name = txtLableType.Text;
            Ruser.Insert(TUser);
            ShowMessage("添加类别" + TUser.Name + "成功！");
        }
        catch (Exception ex)
        {
            ShowMessage("添加类别" + TUser.Name+ "失败！");
        }
        Bind();
    }
}
