﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Data.SqlClient;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Links;
using Base;
using System.Text.RegularExpressions;
public partial class admin_Links_LinksManage : BasePage
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "C1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    #region 绑定数据
    private void Bind()
    {
        CheckRights("column", "C1");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "W_Links";
        PageNo1.FldName = "ID";
        PageNo1.StrGetFields = "*";
        PageNo1.PageSize = pageSize;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
            {
                strWhere = Session["strWhere"].ToString();
            }
            else
            {
                string webNeme = txtName.Text;
                string linkType = dropLinkType.SelectedValue;
                if (GetRequest.GetQueryStringValue("V") != "")
                {
                    switch (GetRequest.GetQueryStringValue("v"))
                    {
                        case "1":
                            this.Label1.CssClass = "pl";
                            strWhere += " and LinkType='" + 1 + "'";
                            break;
                        default:
                            strWhere += " and LinkType='" + 2 + "'";
                            this.Label2.CssClass = "pl";
                            break;
                    }
                }
                if (webNeme != null && webNeme != "")
                {
                    strWhere += " and WebName like '%" + Base.GetRequest.Filter(webNeme) + "%'";
                }
                if (int.Parse(linkType) != 3 && linkType != null)
                {
                    strWhere += " and LinkType='" + Base.GetRequest.Filter(linkType) + "'";
                }
            }
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据！";
            }
            else
                lblMessage.Visible = false;
            
            grdLinks.DataSource = dt.DefaultView;
            grdLinks.DataBind();
        }
        else {
            string webNeme = txtName.Text;
            string linkType = dropLinkType.SelectedValue;
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label1.CssClass = "pl";
                        strWhere += " and LinkType='" + 1 + "'";
                        break;
                    default:
                        strWhere += " and LinkType='" + 2 + "'";
                        this.Label2.CssClass = "pl";
                        break;
                }
            }
            if (webNeme != null && webNeme != "")
            {
                strWhere += " and WebName like '%" + Base.GetRequest.Filter(webNeme) + "%'";
            }
            if (int.Parse(linkType) != 3 && linkType != null)
            {
                strWhere += " and LinkType='" + Base.GetRequest.Filter(linkType) + "'";
            }
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据！";
            } 
            else
                lblMessage.Visible = false;
            grdLinks.DataSource = dt.DefaultView;
            grdLinks.DataBind();
        }       
    }
    #endregion
    protected void grdLinks_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdLinks.PageIndex = e.NewPageIndex;
        Bind();
    }
    protected void grdLinks_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = int.Parse(grdLinks.DataKeys[e.RowIndex].Value.ToString());
        ILinks RLink = new RLinks();
        RLink.Delete(id);
        Bind();
    }
    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        TLinks TLink = new TLinks();
        ILinks RLink = new RLinks();
        string Content = e.CommandArgument.ToString();
        int index = int.Parse(Content.IndexOf("|").ToString());
        if (index < -1 || index + 1 > Content.Length)
            return;
        TLink.ID = int.Parse(Content.Substring(0, index));
        TLink.Verify = Convert.ToBoolean(Content.Substring(index + 1));
        RLink.UpdateVerify(TLink);
        Bind();

    }
    protected void grdLinks_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            if (btn.Text == "已审")
                btn.Attributes.Add("onclick", "javascript:return confirm('你要取消审核吗？')");
            else
                btn.Attributes.Add("onclick", "javascript:return confirm('你要让该会员通过审核吗？请注意该会员是否满足该等级的条件要求！通过审核后,将开通该会员服务功能？')");

        }
    }

    protected void btnSelect_Click(object sender, EventArgs e)
    {
        Bind();
    }    
}
