﻿using System;
using System.Data;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using AdminRights;

public partial class admin_Login : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {           
    }

    protected void ibtnSave_Click(object sender, ImageClickEventArgs e)
    {
        //判断Cookie是否为空如果为空说明浏览器禁用了Cookie
        if (Request.Cookies["CheckCode"] == null)
        {
            lblMessage.Text = "您的浏览器设置已被禁用Cookies,请设置浏览器允许使用Cookies后使用本系统";
        }
        //判断验证码与用户输入的是否相同
        if (string.Compare(Request.Cookies["CheckCode"].Value.ToLower(), txtCheckCode.Text.ToLower()) != 0)
        {
            lblMessage.Visible = true;
            lblMessage.Text = "验证码错误,请输入正确的验证码";
            return;
        }
        string name = txtName.Text.Trim();
        string password = txtPassword.Text.Trim();
        if (!name.Equals(string.Empty) && !password.Equals(string.Empty))
        {
            IManager RMan = new RManager();
            TManager TMan = new TManager();
            string Md5Pawd = Common.Encryption(password);
            DataTable dt = RMan.GetDataTable(name, Md5Pawd);
            TMan.LastIP = Base.GetRequest.GetIP();
            TMan.LastDate = DateTime.Now;
            if (dt.Rows.Count > 0)
            {
                if (dt.Rows[0]["Lockedup"].ToString().Equals("True"))
                {
                    ShowMessage("该帐号已被锁定!", "Login.aspx");
                    return;
                }
                Session["ManagerName"] = name;
                Session["PassWord"] = password;
                Session["ManagerID"] = dt.Rows[0]["ID"];
                Session["RoleID"] = dt.Rows[0]["RoleID"];
                TMan.ID = Convert.ToInt32(dt.Rows[0]["ID"]);
                RMan.UpdateIP(TMan, 1, name);
                Response.Redirect("index.aspx");

            }
            else
            {
                RMan.UpdateIP(TMan,0,name);
                lblMessage.Visible = true;
                lblMessage.Text = "登录失败，用户名及密码输入错误！";
            }
        }
        else
        {
            lblMessage.Visible = true;
            lblMessage.Text = "用户名，密码输入有误";
        }

    }
}
