﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using AdminRights;
using System.Net;
using System.Text.RegularExpressions;

public partial class admin_Rights_ManagerAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("system", "A1");
        if (!IsPostBack)
        {
            RoleBind();
            BindMenu();
        }
    }
    private void RoleBind()
    {
        IRole role = new RRole();
        DataTable dt = role.GetDataTable();
        dropRoleID.DataSource = dt.DefaultView;
        dropRoleID.DataTextField = "RoleName";
        dropRoleID.DataValueField = "ID";
        dropRoleID.DataBind();
    }


    private void BindMenu()
    {
        IRole Role = new RRole();
        DataTable dt = Role.GetDataTable();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            HtmlAnchor lnkRole = new HtmlAnchor();
            lnkRole.HRef = "ManagerList.aspx?ID=" + dt.Rows[i]["ID"].ToString();
            lnkRole.InnerText = " | " + dt.Rows[i]["RoleName"].ToString();
            this.menu.Controls.Add(lnkRole);
        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string Restr = "";
            IManager RManager = new RManager();
            TManager TManager = new TManager();
            if (CompareValidator.Equals(txtManagerName.Text.Trim(), ""))
            {
                Restr += "网站管理员、";
            }
            else
            {
                TManager.ManagerName = txtManagerName.Text.Trim();
            }

            if (CompareValidator.Equals(txtPassWord.Text.Trim(), ""))
            {
                Restr += "管理员密码、";
            }
            else
            {
                string Md5Pawd = Common.Encryption(txtPassWord.Text.Trim());
                TManager.PassWord = Md5Pawd;
            }
            if (Restr != "")
                Restr = Restr.Substring(0, Restr.Length - 1);
            TManager.RoleID = Convert.ToInt32(dropRoleID.SelectedValue);
            TManager.Lockedup = Convert.ToBoolean(radlLockedup.SelectedValue);
            if (Restr == "")
            {
                RManager.Insert(TManager);
                ShowMessage("网站管理员添加成功！", "Rights/ManagerList.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage("网站管理员添加失败！", "Rights/ManagerList.aspx");
        }
    }
}
