﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using AdminRights;

public partial class admin_Rights_ManagerEdit : BasePage
{
    private static string _Password = "";
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("system", "A1");
        if (!IsPostBack)
        {
            BindMenu();
            RoleBind();
            Bind();
        }
    }
    private void Bind()
    { 
        if(Request.QueryString["ID"]!=null&&Request.QueryString["ID"]!="")
        {
            int id =Convert.ToInt32(Request.QueryString["ID"].ToString());
            IManager RManager = new RManager();
            TManager TManager=RManager.GateItem(id);
            txtManagerName.Text = TManager.ManagerName;
            //txtPassWord.Text = TManager.PassWord;
            _Password = TManager.PassWord;
            txtPassWord.Attributes.Add("value", TManager.PassWord.ToString());
            radlLockedup.SelectedValue = TManager.Lockedup.ToString();
            dropRoleID.SelectedValue = TManager.RoleID.ToString();
        }
    }

    private void BindMenu()
    {
        IRole Role = new RRole();
        DataTable dt = Role.GetDataTable();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            HtmlAnchor lnkRole = new HtmlAnchor();
            lnkRole.HRef = "ManagerList.aspx?ID=" + dt.Rows[i]["ID"].ToString();
            lnkRole.InnerText = " | " + dt.Rows[i]["RoleName"].ToString();
            this.menu.Controls.Add(lnkRole);
        }
    }


    private void RoleBind()
    {
        IRole role = new RRole();
        DataTable dt = role.GetDataTable();
        dropRoleID.DataSource = dt.DefaultView;
        dropRoleID.DataTextField = "RoleName";
        dropRoleID.DataValueField = "ID";
        dropRoleID.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
            {
                string Restr = "";
                IManager RManager = new RManager();
                TManager TManager = new TManager();
                if (CompareValidator.Equals(txtManagerName.Text.Trim(), ""))
                {
                    Restr += "网站管理员、";
                }
                else
                {
                    TManager.ManagerName = txtManagerName.Text.Trim();
                }

                if (CompareValidator.Equals(txtPassWord.Text.Trim(),""))
                {
                    Restr += "管理员密码、";
                }
                else
                {
                    if (_Password.Equals(txtPassWord.Text.Trim()))
                    {
                        TManager.PassWord = txtPassWord.Text.Trim();
                    }
                    else
                    {
                        string Md5Pawd = Common.Encryption(txtPassWord.Text.Trim());
                        TManager.PassWord = Md5Pawd;
                    }   
                }
                if (Restr!="")
                    Restr = Restr.Substring(0, Restr.Length - 1);
                int id = Convert.ToInt32(Request.QueryString["ID"].ToString());
                TManager.ID = id;
                TManager.ManagerName = txtManagerName.Text;
                if (_Password.Equals(txtPassWord.Text.Trim()))
                {
                    TManager.PassWord = txtPassWord.Text.Trim();
                }
                else
                {
                    string Md5Pawd = Common.Encryption(txtPassWord.Text.Trim());
                    TManager.PassWord = Md5Pawd;
                } 
                TManager.RoleID = Convert.ToInt32(dropRoleID.SelectedValue);
                TManager.Lockedup = Convert.ToBoolean(radlLockedup.SelectedValue);
                if (Restr == "")
                {
                    RManager.Update(TManager);
                    ShowMessage("网站管理员信息修改成功！", "Rights/ManagerList.aspx");
                }
                else
                {
                    lblMessage.Visible = true;
                    lblMessage.Text = Restr + "填写有误！";
                }
            }
        }
        catch (Exception ex)
        {
            ShowMessage("网站管理员信息修改失败！", "Rights/ManagerList.aspx");
        }
    }
}
