﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using AdminRights;

public partial class admin_Rights_ManagerList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            try
            {
                if (!CheckRights("system", "A1"))
                {
                    HandleErr("您没有对该功能的操作权限", "index_Center.aspx", "1");
                    return;
                }
            }
            catch (Exception ex)
            {
                HttpContext.Current.Response.Write(ex.Message);
            }
            if (!IsPostBack)
            {
                BindMenu();
                Bind();
            }

        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }
    private void Bind()
    {
        string strWhere = "";
        string strid = GetRequest.GetQueryStringValue("id");
        if (strid != "")
        {
            if (Common.CheckNum(GetRequest.GetQueryStringValue("id")))
            {
                strWhere = " where RoleID =" + strid;
            }
        }
        IManager manager = new RManager();
        DataTable dt = manager.GetDataTable(strWhere);
        grvManager.DataSource = dt.DefaultView;
        grvManager.DataBind();
    }

    private void BindMenu()
    {
        IRole Role = new RRole();
        DataTable dt = Role.GetDataTable();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            HtmlAnchor lnkRole = new HtmlAnchor();
            lnkRole.HRef = "ManagerList.aspx?ID=" + dt.Rows[i]["ID"].ToString();
            lnkRole.InnerText = " | " + dt.Rows[i]["RoleName"].ToString();
            this.menu.Controls.Add(lnkRole);
        }
    }

    public string GetShortDate(string strDate)
    {
        if (strDate != string.Empty)
        {
            return Convert.ToDateTime(strDate.ToString()).ToShortDateString();
        }
        else
            return string.Empty;
    }

    protected void grvRole_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(grvManager.DataKeys[e.RowIndex].Value);
        IRole Role = new RRole();
        Role.Delete(id);
    }

    protected void grvManager_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grvManager.PageIndex = e.NewPageIndex;
        Bind();
    }

    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        //更新锁定信息
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;
        TManager TManager = new TManager();
        TManager.ID = Convert.ToInt32(Content.Substring(0, index));
        TManager.Lockedup = Convert.ToBoolean(Content.Substring(index + 1));
        IManager RManager = new RManager();
        RManager.UpdateLockedup(TManager);
        Bind();
    }

    protected void grvManager_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        
        //弹出警告对话框
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");
            if (btn.Text == "已锁定")
                btn.Attributes.Add("onclick", "javascript:return confirm('你要取消锁定吗？')");
            else
                btn.Attributes.Add("onclick", "javascript:return confirm('你确定要锁定吗？')");

        }
        //判断是否是超级管理
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            if (e.Row.Cells[0].Text == "1")
            {
                LinkButton hlk1 = (LinkButton)e.Row.FindControl("lbtnUpdate");
                if (hlk1!=null)
                {
                    hlk1.Enabled = false;
                    hlk1.Attributes.Clear();
                }
                LinkButton hlk3 = (LinkButton)e.Row.FindControl("LinkButton1");
                if (hlk3!=null)
                {
                    hlk3.Visible = false;
                }
                LinkButton hlk4 = (LinkButton)e.Row.FindControl("LinkButton2");
                if (hlk4!=null)
                {
                    hlk4.Visible = true;
                }
            }
        }
    }

    protected void grvManager_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int id = Convert.ToInt32(grvManager.DataKeys[e.RowIndex].Value);
        IManager manager = new RManager();
        manager.Delete(id);
        Bind();
    }

}
