﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using AdminRights;


public partial class admin_Rights_RoleEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (!CheckRights("system", "A1"))
            {
                HandleErr("您没有对该功能的操作权限", "index_Center.aspx", "1");
                return;
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }

        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            int id = Convert.ToInt32(Request.QueryString["ID"].ToString());
            this.ViewState["id"] = id;
            IRole Role = new RRole();
            TRole TRole = Role.GetItem(id);
            txtRoleName.Text = TRole.RoleName;
            this.txtDescribe.Text = TRole.Describe.ToString();
            string[] str;
            if (TRole.Basic != "")
            {
                str = TRole.Basic.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i].Substring(1, 1) == "1")
                    {
                        chkBasic.Items[i].Selected = true;
                    }
                }
            }
            str = null;
            if (TRole.Column != "")
            {
                str = TRole.Column.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i].Substring(1, 1) == "1")
                    {
                        chkColumn.Items[i].Selected = true;
                    }
                }
            }
            str = null;
            if (TRole.User != "")
            {
                str = TRole.User.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i].Substring(1, 1) == "1")
                    {
                        chkUser.Items[i].Selected = true;
                    }
                }
            }
            str = null;
            if (TRole.Template != "")
            {
                str = TRole.Template.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i].Substring(1, 1) == "1")
                    {
                        chkTemplate.Items[i].Selected = true;
                    }
                }
            }
            str = null;
            if (TRole.System != "")
            {
                str = TRole.System.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (str[i].Substring(1, 1) == "1")
                    {
                        chkSystem.Items[i].Selected = true;
                    }
                }
            }
            str = null;

        }
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        string Restr = "";
        //常规管理
        string myValue = "";
        foreach (ListItem li in chkBasic.Items)
        {
            if (li.Selected)
            {
                myValue += li.Value + "1,";
            }
            else
            {
                myValue += li.Value + "0,";
            }

        }
        if (myValue != "")
        {
            myValue = myValue.Substring(0, myValue.Length - 1);
        }
        string strBasic = myValue;
        //栏目管理
        myValue = string.Empty;
        foreach (ListItem li in chkColumn.Items)
        {
            if (li.Selected)
            {
                myValue += li.Value + "1,";
            }
            else
            {
                myValue += li.Value + "0,";
            }

        }
        if (myValue != "")
        {
            myValue = myValue.Substring(0, myValue.Length - 1);
        }
        string strColumn = myValue;
        //会员管理
        myValue = string.Empty;
        foreach (ListItem li in chkUser.Items)
        {
            if (li.Selected)
            {
                myValue += li.Value + "1,";
            }
            else
            {
                myValue += li.Value + "0,";
            }

        }
        if (myValue != "")
        {
            myValue = myValue.Substring(0, myValue.Length - 1);
        }
        string strUser = myValue;
        //模板风格
        myValue = string.Empty;
        foreach (ListItem li in chkTemplate.Items)
        {
            if (li.Selected)
            {
                myValue += li.Value + "1,";
            }
            else
            {
                myValue += li.Value + "0,";
            }

        }
        if (myValue != "")
        {
            myValue = myValue.Substring(0, myValue.Length - 1);
        }
        string strTemplate = myValue;
        //系统设置
        myValue = string.Empty;
        foreach (ListItem li in chkSystem.Items)
        {
            if (li.Selected)
            {
                myValue += li.Value + "1,";
            }
            else
            {
                myValue += li.Value + "0,";
            }

        }
        if (myValue != "")
        {
            myValue = myValue.Substring(0, myValue.Length - 1);
        }
        string strSystem = myValue;
        myValue = string.Empty;

        TRole TR = new TRole();
        if (txtRoleName.Text.Trim().Equals(string.Empty))
        {
            Restr += "网站角色，";
        }
        TR.RoleName = txtRoleName.Text;
        TR.Basic = strBasic;
        TR.Column = strColumn;
        TR.User = strUser;
        TR.Template = strTemplate;
        TR.System = strSystem;
        TR.Describe = txtDescribe.Text.Trim();
        try
        {
            if (this.ViewState["id"].ToString() != "")
            {
                if (Common.CheckNum(this.ViewState["id"].ToString()))
                {
                    TR.ID = int.Parse(this.ViewState["id"].ToString());
                }
                else
                {
                    ShowMessage("不存在修改的角色！", "Rights/Rolelist.aspx");
                    return;
                }
            }
            else
            {
                ShowMessage("不存在修改的角色！", "Rights/Rolelist.aspx");
                return;
            }
            IRole Role = new RRole();
            if (!Restr.Equals(string.Empty))
                Restr = Restr.Substring(0, Restr.Length - 1);
            if (Restr.Trim().Equals(string.Empty))
            {
                Role.Update(TR);
                ShowMessage("网站角色修改成功！", "Rights/RoleList.aspx");
            }
            else
            {
                lblMessage.Visible = true;
                lblMessage.Text = Restr + "填写有误！";
            }
        }
        catch (Exception ex)
        {
            ShowMessage("网站角色修改失败！", "Rights/RoleList.aspx");
        }
    }
}
