﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using AdminRights;

public partial class admin_Rights_RoleList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            if (!CheckRights("system", "A1"))
            {
                HandleErr("您没有对该功能的操作权限", "index_Center.aspx", "1");
                return;
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
        if (!IsPostBack)
        {
            Bind();
        }
    }

    private void Bind()
    {
        IRole Role = new RRole();
        DataTable dt=Role.GetDataTable();
        grvRole.DataSource = dt.DefaultView;
        grvRole.DataBind();
        for (int i = 0; i < dt.Rows.Count; i++)
        {
            HtmlAnchor lnkRole = new HtmlAnchor();
            lnkRole.HRef = "ManagerList.aspx?ID=" + dt.Rows[i]["ID"].ToString();
            lnkRole.InnerText =" | " + dt.Rows[i]["RoleName"].ToString();
            this.menu.Controls.Add(lnkRole);
        }
    }


    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }



    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        


        //更新锁定信息
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;
        TRole TR = new TRole();
        TR.ID = Convert.ToInt32(Content.Substring(0, index));
        if (Convert.ToBoolean(Content.Substring(index + 1)))
            TR.Authorize = false;
        else
            TR.Authorize = true;
        IRole RR = new RRole();
        RR.UpdateVerify(TR);
        Bind();
    }


    /// <summary>
    ///  
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtdelete_Command(object sender, CommandEventArgs e)
    {
        int id = int.Parse(e.CommandArgument.ToString());
        IRole Role = new RRole();
        Role.Delete(id);
        Bind();
    }



    protected void grvRole_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
            if (e.Row.Cells[0].Text == "1" || e.Row.Cells[1].Text == "超级管理员组")
            {
                Panel pan = (Panel)e.Row.FindControl("admin");
                pan.Visible = false;
                Panel pan1 = (Panel)e.Row.FindControl("Panel1");
                pan1.Visible = true;
            }
            //LinkButton btn = (LinkButton)e.Row.FindControl("lbtnUpdate");

        }

    }

}
