﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using SqlOperate;
using Base;
using AdminRights;


public partial class Admin_Rights_SqlDAL : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Base.BasePage.CheckRights("system", "B1");
        Base.XMLProcess xp = new Base.XMLProcess("xml/Common.config");
        string strManager = xp.Read("/configuration/safesetting/manager");
        string strMode = xp.Read("/configuration/safesetting/mode");
        string strDate = xp.Read("/configuration/safesetting/date");
        try
        {
            if (HttpContext.Current.Session["ManagerName"].ToString() != strManager)
            {
                Base.BasePage.ShowMessage("对不起您没有权限操作数据库", "index_center.aspx");
            }
            else
            {
                if (strMode == "true")
                {
                    if (DateTime.Compare(Convert.ToDateTime(strDate), DateTime.Now.Date) < 0)
                    {
                        Base.BasePage.ShowMessage("该时间段不能操作数据库，请修改配置文件里的时间", "index_center.aspx");
                    }
                }
                else
                {
                    Base.BasePage.ShowMessage("对不起您能操作数据库，请修改配置文件里的设置", "index_center.aspx");
                }
            }
        }
        catch
        {
            Base.BasePage.ShowMessage("xml/common.config配置文件里的设置有问题,请重新设置", "index_center.aspx");
        }
    }
    protected void btnSumit_Click(object sender, EventArgs e)
    {
        try
        {
            if (txtSql.Text.Trim() == "")
            {
                this.message.Visible = true;
                this.message.InnerHtml = "&nbsp;&nbsp;<img src=\"../images/err.gif\" alt=\"\">&nbsp;请输入操作数据库语句";
            }
            else
            {
                SqlHelper.ExecuteNonQuery(txtSql.Text.Trim());
                this.message.Visible = true;
                this.message.InnerHtml = "&nbsp;&nbsp;<img src=\"../images/ok.gif\" alt=\"\">&nbsp;操作成功。如果不在操作，请修改回XML/common.config文件原来的设置";
            }
            
        }
        catch(Exception ex)
        {
            this.message.Visible = true;
            this.message.InnerHtml = "&nbsp;&nbsp;<img src=\"../images/err.gif\" alt=\"\">&nbsp;操作失败，错误提示：&nbsp;&nbsp;" + ex.Message;
        }
    }
}
