﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Email.Subscription;

public partial class Admin_Subscription_SubscriptionProductEdit : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            Bind();
        }

    }
    private void Bind()
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            SubscriptionProduct product = new SubscriptionProduct();
            SubscriptionProduct prod = product.GetItem(id);
            if (prod.Type != "")
            {
                for (int i = 0; i < chklProduct.Items.Count; i++)
                {
                    if (prod.Type == chklProduct.Items[i].Value)
                        chklProduct.Items[i].Selected = true;

                }
            }
            txtKeyword.Text = prod.Keyword;
            if (prod.Area != "")
            {
                string[] strArea = prod.Area.Split(new char[] { ',' });
                txtProvince.Value = strArea[0];
                txtCity.Value = strArea[1];
                txtCounty.Value = strArea[2];
            }
            if (prod.Indtype != null)
            {
                string[] str = prod.Indtype.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (i == 0)
                        this.txtSortB.Value = str[i];
                    else if (i == 1)
                        this.txtSortM.Value = str[i];
                    else
                        this.txtSortS.Value = str[i];
                }
            }
            dropValidity.SelectedValue = prod.Validity.ToString();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request.QueryString["ID"] != null && Request.QueryString["ID"] != "")
        {
            try
            {
                int id = int.Parse(Request.QueryString["ID"].ToString());
                SubscriptionProduct product = new SubscriptionProduct();
                product.ID = id;
                string myValue = "";
                myValue += Request.Form["SortB"];
                myValue += ',' + Request.Form["SortM"];
                myValue += ',' + Request.Form["SortS"];
                product.Indtype = myValue;
                myValue = "";
                product.Type = chklProduct.SelectedValue;
                product.Keyword = txtKeyword.Text.Trim();
                myValue += Request.Form["province"] + ',';
                myValue += Request.Form["city"] + ',';
                myValue += Request.Form["county"];
                product.Area = myValue;
                product.Validity = int.Parse(dropValidity.SelectedValue);
                product.Update(product);
                ShowMessage("商机订阅成功！", "Subscription/SubscriptionProductList.aspx");


            }
            catch (Exception ex)
            {
                ShowMessage("商机订阅失败！", "Subscription/SubscriptionProductList.aspx");
            }
        }
    }
}
