﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Email.Subscription;
using SqlOperate;
using nspEmail.Lables;
using nspBase.Core;

public partial class Admin_Subscription_SubscriptionProductList : Base.BasePage
{
    public string strEmail;
    public string strbody;
    public string strTitle;
    string strInfoMessage;
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "D1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.FldName = "temps.UserID";
        PageNo1.Table = "(select UserID from U_SubscriptionProduct group by UserID) temps inner join U_UserInfo b on temps.UserID=b.UserID inner join U_SubscriptionEmail c on temps.UserID=c.UserID";
        PageNo1.StrGetFields = "temps.UserID,b.LoginName,c.Email";
        PageNo1.PageSize = 5;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
            {
                PageNo1.Where = Session["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where = "1=1";
            }
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
            {
                lblMessage.Visible = false;
            }
            dlstSubscription.DataSource = dt.DefaultView;
            dlstSubscription.DataBind();
        }
        else
        {
            Session["strWhere"] = "1=1";
            PageNo1.Where = "1=1";
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
            {
                lblMessage.Visible = false;
            }
            dlstSubscription.DataSource = dt.DefaultView;
            dlstSubscription.DataBind();
        }
    }
    /// <summary>
    /// 删除单条数据
    /// </summary>
    /// <param name="source"></param>
    /// <param name="e"></param>
    protected void dlstSubscription_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = int.Parse(((Label)e.Item.FindControl("lblUserId")).Text);
        SubscriptionProduct product = new SubscriptionProduct();
        product.Delete(id);
        Bind();
       
    }
    /// <summary>
    /// 批量发送
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSend_Click(object sender, EventArgs e)
    {
        string strInfo = "";
        string sql = "select Content,Title from W_EmailTemplate  where Flag='us_SubScriptionProduct'";
        DataTable dt = SqlHelper.ExecuteSqlQuery(sql);
        if (dt.Rows.Count != 0)
        {
            string strModes = dt.Rows[0]["Content"].ToString();
            strTitle = dt.Rows[0]["Title"].ToString();
            dt.Clear();
            dt.Dispose();

            for (int i = 0; i < dlstSubscription.Items.Count; i++)
            {
                CheckBox cbx = (CheckBox)dlstSubscription.Items[i].FindControl("CheckBox1");
                if (cbx.Checked)
                {
                    EmailTempinc.strUserName = ((Label)dlstSubscription.Items[i].FindControl("lblLoginName")).Text;
                    strEmail = ((Label)dlstSubscription.Items[i].FindControl("lblEmail")).Text;
                    strbody = new EmailTempinc().Hope_htmlAll(strModes);

                    if (strbody.ToUpper() != "NOT FIND")
                    {
                        System.Threading.Thread thread = new System.Threading.Thread(new System.Threading.ThreadStart(dowork));
                        thread.Start();

                    }

                }
            }
        }
    }
    public void dowork()
    {
        strInfoMessage = clsEmail.SendMail(strEmail, strTitle, strbody, true);

    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < dlstSubscription.Items.Count; i++)
        {
            CheckBox cbx = (CheckBox)dlstSubscription.Items[i].FindControl("CheckBox1");
            if (cbx.Checked)
            {
                int id = int.Parse(((Label)dlstSubscription.Items[i].FindControl("lblUserId")).Text);
                SubscriptionProduct product = new SubscriptionProduct();
                product.Delete(id);

            }
        }
        Bind();
    }
    protected void dlstSubscription_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            string strUserId = ((Label)e.Item.FindControl("lblTypeInfo")).Text;
            if (strUserId != null)
                strUserId = strUserId.ToString().Trim();
            string sql = "select Keyword from U_SubscriptionProduct where  UserID='" + strUserId + "' ";
            string strtype = "";
            DataTable dt = SqlHelper.ExecuteSqlQuery(sql);
            for (int i = 0; i < dt.DefaultView.Count; i++)
            {
                if (i == dt.DefaultView.Count - 1)
                    strtype += dt.Rows[i]["Keyword"].ToString();
                else
                    strtype += dt.Rows[i]["Keyword"].ToString() + ",";
            }
            ((Label)e.Item.FindControl("lblTypeInfo")).Text = strtype;
            dt.Clear();
            dt.Dispose();
        }
    }
}
