﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;

public partial class admin_Templates_OtherList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "C1");
        Base.XMLProcess xp = new Base.XMLProcess("xml/Template.xml");
        System.Xml.XmlNodeList str = xp.ReadAllChild("/template/other");
        BuildTable(str);
    }


    private void BuildTable(System.Xml.XmlNodeList nodelist)
    {
        
        if (nodelist.Count > 0)
        {
            BuilderTableHead();
            foreach (System.Xml.XmlElement el in nodelist)//读元素值
            {

                //创建行
                TableRow tr = new TableRow();
                tr.Attributes.Add("onMouseOver", "SetNewColor(this);");
                tr.Attributes.Add("onMouseOut", "SetOldColor(this);");
                this.tabList.Rows.Add(tr);

                // ID
                TableCell tdID = new TableCell();
                tdID.CssClass = " nolet";
                tdID.Text = el.Attributes["id"].Value.ToString();
                tr.Cells.Add(tdID);

                //Name
                TableCell tdName = new TableCell();
                tdName.CssClass = "left2";
                tdName.Text = el.Attributes["name"].Value.ToString();
                tr.Cells.Add(tdName);

                //备注
                TableCell tcRemark = new TableCell();
                tcRemark.Text = el.Attributes["remarks"].Value.ToString();
                tr.Cells.Add(tcRemark);

                //Edit
                TableCell tdEdit = new TableCell();
                tdEdit.Text = "<a href=\"Other.aspx?t=" + el.Attributes["name"].Value.ToString() + "\">" + "编辑</a>";
                tr.Cells.Add(tdEdit);

            }
        }

    }



    /// <summary>
    /// table头部
    /// </summary>
    private void BuilderTableHead()
    {
        //创建行
        TableFooterRow tr = new TableFooterRow();
        tr.CssClass = "header";
        this.tabList.Rows.Add(tr);

        // ID

        TableHeaderCell tID = new TableHeaderCell();
        tID.CssClass = "th20 tou";
        tID.Text = "ID";
        tr.Cells.Add(tID);

        //Name
        TableHeaderCell tName = new TableHeaderCell();
        tName.Text = "模板名称";
        tr.Cells.Add(tName);

        // ID
        TableHeaderCell tcRemark = new TableHeaderCell();
        ////tcRemark.CssClass = "th180";
        tcRemark.Text = "备注";
        tr.Cells.Add(tcRemark);

        //Edit
        TableHeaderCell tdEdit = new TableHeaderCell();
        tdEdit.CssClass = "th180";
        tdEdit.Text = "编辑";
        tr.Cells.Add(tdEdit);
    }
}
