﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using Base;

public partial class admin_Templates_ShopTemplateEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "B1");
        if (!IsPostBack)
        {
            if (Request.QueryString["url"] == null)
                return;
            else
            {

                string Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + "/ShopTemplate/" + Request.QueryString["url"];
                StringBuilder builder = new StringBuilder();
                using (System.IO.StreamReader reader = new System.IO.StreamReader(Path, Encoding.Default))
                {
                    builder.Append(reader.ReadToEnd());
                    reader.Close();
                }
                this.Title.Text = Request.QueryString["url"];
                this.Title.ReadOnly = true;
                this.txtContent.Text = builder.ToString();
                this.ViewState["path"] = Path;
            }
        }
    }


    /// <summary>
    /// 保存修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            System.IO.File.WriteAllText(this.ViewState["path"].ToString(), this.txtContent.Text, Encoding.Default);
            Response.Redirect("ShopTemplateList.aspx");
        }
        catch
        {
            Base.BasePage.ShowMessage("文件的权限不够，请修改文件权限！");
        }
    }
}
