﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;

public partial class admin_Templates_ShopTemplateList : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "B1");
        if (!IsPostBack)
        {
           
            if (Base.GetRequest.GetQueryStringValue("id") == "")
            {

                BuildTable();
            }
            else
            {
                BuildDirList();
                // BuildDynaControl();
            }
        }
        else
        {
            System.Collections.ArrayList list = this.ViewState["CheckBoxList"] as System.Collections.ArrayList;
            if (list.Count > 0)
            {
                for (int i = 0; i < list.Count; i++)
                {
                    CheckBox bt = new CheckBox();
                    bt.ID = "bt" + list[i];
                    TableRow tr = new TableRow();
                    this.TblDirList.Rows.Add(tr);
                    TableCell tc = new TableCell();
                    tr.Cells.Add(tc);
                    tc.Controls.Add(bt);
                    this.TblDirList.Rows.Add(tr);
                }                
            }
            Button bb = new Button();
            bb.ID = "btCancel";
            bb.Click += new EventHandler(btCancel_Click);
            TableRow tr1 = new TableRow();
            this.TblDirList.Rows.Add(tr1);
            TableCell tc1 = new TableCell();
            tr1.Cells.Add(tc1);
            tc1.Controls.Add(bb);
            this.TblDirList.Rows.Add(tr1);

        }
    }


    private void BuildTable()
    {

        this.TblDirList.Rows.Clear();
        BuilderFileHead();
        Base.XMLProcess xp = new Base.XMLProcess("xml/Template.xml");
        System.Xml.XmlNodeList nodelist = xp.ReadAllChild("/template/shop");
        

        int m = 0;
        int intStart = 0;
        int intEnd = 10;
        if (Base.GetRequest.GetQueryStringValue("page") != "")
        {
            if (Base.Common.CheckNum(Base.GetRequest.GetQueryStringValue("page")))
            {
                m = int.Parse(Base.GetRequest.GetQueryStringValue("page")) * 10;
                intStart = m;
                intEnd = intStart + 10;
            }
        }
        int num = m+ 10;
        if (nodelist.Count > 0)
        {
            int i = 0;
            System.Collections.ArrayList list1 = new ArrayList();
            foreach (System.Xml.XmlElement el in nodelist)//读元素值
            {

                if(i >= intStart && i < intEnd)
                {
                    //if (int.Parse(el.Attributes["id"].Value.ToString()) >= i && int.Parse(el.Attributes["id"].Value.ToString()) < num)
                    //{

                        //创建行
                        TableRow tr = new TableRow();
                        tr.Attributes.Add("onMouseOver", "SetNewColor(this);");
                        tr.Attributes.Add("onMouseOut", "SetOldColor(this);");

                        this.TblDirList.Rows.Add(tr);
                        //复选框
                        TableCell tChk = new TableCell();
                        CheckBox chk = new CheckBox();
                        chk.ID = "bt" + el.Attributes["id"].Value.ToString();
                        tChk.Controls.Add(chk);
                        tChk.CssClass = "nolet";
                        tr.Cells.Add(tChk);
                        list1.Add(el.Attributes["id"].Value.ToString());

                        //Name
                        TableCell tName = new TableCell();
                        tName.CssClass = "left2";
                        tName.Text = el.Attributes["value"].Value.ToString();
                        tr.Cells.Add(tName);

                        ////审核
                        //TableCell tv = new TableCell();
                        //tv.Text = "审核";
                        //tr.Cells.Add(tv);

                        //Edit
                        TableCell tEdit = new TableCell();
                        tEdit.Text = "<a href=\"ShopTemplateList.aspx?id=" + el.Attributes["id"].Value.ToString() + "\">" + "查看</a>";
                        tr.Cells.Add(tEdit);
                        if (i >= num)
                            break;
                        
                    //}
                }
                i++;
            }
            this.ViewState["CheckBoxList"] = list1;
            string strpage = "";
            TableRow tb = new TableRow();
            this.TblDirList.Rows.Add(tb);
            TableCell tpage = new TableCell();
            int intCount = nodelist.Count % 10 ==0 ? nodelist.Count / 10 : nodelist.Count / 10 + 1;
            for (int j = 0; j < intCount; j++)
            {
                strpage += "<a href=\"?page=" + j.ToString() + "\">" + "&nbsp;&nbsp;" + (j + 1) + "</a>";
            }
            tpage.ColumnSpan = 3;
            tpage.CssClass = "Paging";

            System.Web.UI.WebControls.Label lblpage = new System.Web.UI.WebControls.Label();
            lblpage.Text = "<p>" +strpage+ "</p>";
            lblpage.ID = "lalPage";
            tpage.Controls.Add(lblpage);

            CheckBox chkAll = new CheckBox();
            chkAll.ID = "chkAll";
            chkAll.Text = "全选";
            
            tpage.Controls.Add(chkAll);



            Button bt = new Button();
            bt.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
            bt.ID = "btCancel";
            bt.Text = "批量删除";
            bt.Click += new EventHandler(btCancel_Click);
			bt.CssClass="i_button";
            tpage.Controls.Add(bt);



            tb.Cells.Add(tpage);
        }

    }

    private void BuilderFileHead()
    {
        //创建行
        TableFooterRow tr = new TableFooterRow();
        tr.CssClass = "header";
        this.TblDirList.Rows.Add(tr);

        // ID
        TableHeaderCell tChk = new TableHeaderCell();
        tChk.CssClass = "th20 tou";
        tr.Cells.Add(tChk);

        //// ID
        //TableHeaderCell tID = new TableHeaderCell();
        //tID.Text = "ID";
        //tr.Cells.Add(tID);

        //Name
        TableHeaderCell tName = new TableHeaderCell();
        //tName.ColumnSpan = 2;
        tName.Text = "名称";
		tName.CssClass = "left2";
        tr.Cells.Add(tName);

        //// 审核
        //TableCell tPic = new TableHeaderCell();
        //tPic.Text = "审核";
        //tr.Cells.Add(tPic);

        //Edit
        TableHeaderCell tEdit = new TableHeaderCell();
        tEdit.CssClass = "th80";
        tEdit.Text = "管理";
        tr.Cells.Add(tEdit);
    }


    string CurrentPath
    {
        get
        {
            string path = this.ViewState["CurrentPath"] as string;
            if (path == null)
                path = "";
            return path;
        }

        set
        {
            this.ViewState["CurrentPath"] = value;
        }
    }

    /// <summary>
    /// 创建目录列表 
    /// </summary>
    private void BuildDirList()
    {
        string str = Base.XMLProcess.Read("Xml/Template.xml", "/template/shop/mode[@id='" + Request.QueryString["id"] + "']", "url");
        string ActualPath = AppDomain.CurrentDomain.BaseDirectory.ToString() + "ShopTemplate\\" + str;
        // 清除原有的行                                                         
        this.TblDirList.Rows.Clear();

        // 添加表格的标题

        TableFooterRow tr = new TableFooterRow();
        tr.CssClass = "header";
        this.TblDirList.Rows.Add(tr);

        // 添加五列标题

        TableHeaderCell iconCell = new TableHeaderCell();
        iconCell.ColumnSpan = 2;
        iconCell.CssClass = "tou";
        iconCell.Text = "名称";
        tr.Cells.Add(iconCell);

        TableHeaderCell sizeCell = new TableHeaderCell();
        sizeCell.CssClass = "th80";
        sizeCell.Text = "大小";
        tr.Cells.Add(sizeCell);

        TableHeaderCell createCell = new TableHeaderCell();
        createCell.CssClass = "th80";
        createCell.Text = "创建日期";
        tr.Cells.Add(createCell);

        TableHeaderCell modifyCell = new TableHeaderCell();
        modifyCell.CssClass = "th80";
        modifyCell.Text = "修改日期";
        tr.Cells.Add(modifyCell);

        TableHeaderCell editCell = new TableHeaderCell();
        editCell.CssClass = "th80";
        editCell.Text = "编辑";
        tr.Cells.Add(editCell);

        System.Collections.ArrayList list = new ArrayList();

        // 取得子目录
        //string[] dirs = System.IO.Directory.GetDirectories(ActualPath + this.CurrentPath);
        //BuildTable(true, list, dirs);
        //this.ViewState["DirList"] = list;

        // 取得文件列表
        // System.Collections.ArrayList filelist = new ArrayList();
        string[] files;
        if (System.IO.Directory.Exists(ActualPath))
        {
            files = System.IO.Directory.GetFiles(ActualPath);
            BuildTable(false, str, files);
        }
        else
        {
            this.errMessage.Visible = true;
            this.errMessage.Text = "不存在该模板！";
            return;
        }
        //this.ViewState["FileList"] = filelist;

        // 显示当前目录
        // this.LblPath.Text = this.CurrentPath;
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="isDir"></param>
    /// <param name="list"></param>
    /// <param name="dirs"></param>
    private void BuildTable(bool isDir,string str, string[] dirs)
    {



        foreach (string dir in dirs)
        {
            // 取得目录名
            string shortdirname = System.IO.Path.GetFileName(dir);
            System.Web.UI.WebControls.Label lblName = new System.Web.UI.WebControls.Label();
            lblName.Text = shortdirname;
            lblName.ID = shortdirname;

            // 创建一行
            TableRow tr = new TableRow();
            this.TblDirList.Rows.Add(tr);

            // 创建图标格
            TableCell iconCell = new TableCell();
            iconCell.CssClass = "th20 tou";
            Control iconCtl = null;
            if (isDir)          // 目录
            {
                iconCtl = new Image();
                iconCtl.ID = "Btn" + shortdirname;      // 回发的控件一定要有ID
                ((Image)iconCtl).ImageUrl = "../images/folder.gif";
            }
            else　　　　　　　　// 文件
            {
                iconCtl = new Image();
                iconCtl.ID = "Btn" + shortdirname;      // 回发的控件一定要有ID
                ((Image)iconCtl).ImageUrl = "../images/file.gif";

            }
            iconCell.Controls.Add(iconCtl);
            tr.Cells.Add(iconCell);

            // 创建名字格
            TableCell nameCell = new TableCell();
            nameCell.HorizontalAlign = HorizontalAlign.Left;
			nameCell.CssClass = "left2";
            // 复选框放入表格中
            //nameCell.Controls.Add(cb);
            nameCell.Controls.Add(lblName);
            tr.Cells.Add(nameCell);

            // 尺寸
            TableCell sizeCell = new TableCell();

            tr.Cells.Add(sizeCell);
            if (!isDir)   // 文件计算大小
            {
                // 创建文件的实例
                System.IO.FileInfo fi = new System.IO.FileInfo(dir);
                double length = fi.Length;
                string lengthString = null;
                if (length > 1024 * 1024)
                {
                    lengthString = String.Format("{0:f}MB", Convert.ToInt32(length) / 1024 / 1024);
                }
                else if (length > 1024)
                {
                    lengthString = String.Format("{0}KB", Convert.ToInt32(length) / 1024);
                }
                else if (length > 0)
                {
                    lengthString = "1KB";
                }
                else
                {
                    lengthString = "0KB";
                }
                sizeCell.Text = lengthString;
            }

            // 创建日期
            TableCell createCell = new TableCell();
            tr.Cells.Add(createCell);
            createCell.Text = System.IO.File.GetCreationTime(dir).ToShortDateString();

            // 修改日期
            TableCell modifyCell = new TableCell();
            tr.Cells.Add(modifyCell);
            modifyCell.Text = System.IO.File.GetLastWriteTime(dir).ToShortDateString();

            // 修改
            TableCell editCell = new TableCell();
            tr.Cells.Add(editCell);
            editCell.Text = "<a href=\"ShopTemplateEdit.aspx?url=" +str +"/" +shortdirname + "\">" + "编辑</a>";
        }
        // 创建一行
        TableRow re = new TableRow();
        this.TblDirList.Rows.Add(re);
        // 创建日期
        TableCell reCell = new TableCell();
        reCell.ColumnSpan = 6;
        re.Cells.Add(reCell);
        HyperLink bt=new HyperLink();
        bt.ID = "btCancel";
        bt.Text = "返回";
        bt.NavigateUrl = "ShopTemplateList.aspx";
        reCell.Controls.Add(bt);
    }


    void btCancel_Click(object sender,EventArgs e)
    {
        System.Collections.ArrayList list = this.ViewState["CheckBoxList"] as System.Collections.ArrayList;
        for (int i = 0; i < TblDirList.Rows.Count-1; i++)
        {
            CheckBox cbox = (CheckBox)TblDirList.Rows[i].Cells[0].FindControl("bt"+list[i]);
            if (cbox.Checked == true)
            {
                Base.XMLProcess xp = new Base.XMLProcess("xml/Template.xml");
                System.Xml.XmlNodeList nodelist = xp.ReadAllChild("/template/shop");
                Base.XMLProcess.Delete("xml/Template.xml", "/template/shop/mode[@id='" + list[i] + "']");
                //Response.Write(cbox.ID);
            }
        }
        BuildTable();
    }
}
