﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;
using System.IO;
using nspLable.Manage;

public partial class admin_Templates_TemplateEdit : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        string dir = Request.QueryString["md"].ToString();
       
        //UnitBind();
        if (!IsPostBack)
        {
            GetTemplate(dir);
            SystemLableTypeBind();
            UserLableTypeBind();
        }
    }
    /// <summary>
    /// 系统标签类别绑定
    /// </summary>
    private void SystemLableTypeBind()
    {
        ISystemLableType RSystem = new RSystemLableType();
        DataTable dt=RSystem.GetDataTable();
        dropSystemLable.DataSource = dt.DefaultView;
        dropSystemLable.DataTextField = "Name";
        dropSystemLable.DataValueField = "ID";
        dropSystemLable.DataBind();
        ListItem li = new ListItem("常用标签", "0");
        dropSystemLable.Items.Add(li);
        li.Selected = true;
        int TypeID = int.Parse(dropSystemLable.SelectedValue);
        SystemLableBind(TypeID);
    }

    ///// <summary>
    ///// 系统标签绑定
    ///// </summary>
    private void SystemLableBind(int TypeID)
    {
        if (TypeID > 0)
        {
            ISystemLable RSys = new RSystemLable();
            DataTable dt1 = RSys.GetDataTable(TypeID);
            lstSystemLable.DataSource = dt1.DefaultView;
            lstSystemLable.DataTextField = "Remarks";
            lstSystemLable.DataValueField = "Name";
            lstSystemLable.DataBind();
        }
        else
        {
            lstSystemLable.Items.Clear();
            ListItem l0 = new ListItem();
            l0 = new ListItem("网站地址", "PB_WebURL", true);
            lstSystemLable.Items.Add(l0);
            ListItem l1 = new ListItem();
            l1 = new ListItem("网站LOGO", "PB_WebLOGO", true);
            lstSystemLable.Items.Add(l1);
            ListItem l2 = new ListItem();
            l2 = new ListItem("网站名称", "PB_WebNAME", true);
            lstSystemLable.Items.Add(l2);
            ListItem l3 = new ListItem();
            l3 = new ListItem("联系电话", "PB_WebTEL", true);
            lstSystemLable.Items.Add(l3);
        }
    }
    /// <summary>
    /// 用户标签类别绑定
    /// </summary>
    private void UserLableTypeBind()
    {
        IUserLableType RUser = new RUserLableType();
        DataTable dt=RUser.GetDataTable();
        dropUserLable.DataSource = dt.DefaultView;
        dropUserLable.DataTextField = "Name";
        dropUserLable.DataValueField = "ID";
        dropUserLable.DataBind();


        int TypeID = int.Parse(dropUserLable.SelectedValue);
        UserLableBind(TypeID);
    }
    /// <summary>
    /// 用户标签绑定
    /// </summary>
    private void UserLableBind(int TypeID)
    {
        IUserLable RUs = new RUserLable();
        DataTable dt1 = RUs.GetDataTable(TypeID);
        lstUserLable.DataSource = dt1.DefaultView;
        lstUserLable.DataTextField = "Remarks";
        lstUserLable.DataValueField = "LableName";
        lstUserLable.DataBind();
    }
    /// <summary>
    /// 获取模板
    /// </summary>
    /// <param name="pathName">模板路径</param>
    /// <returns></returns>
    public void GetTemplate(string pathName)
    {
        StringBuilder builder = new StringBuilder();
        string str = "";
        string Path = AppDomain.CurrentDomain.BaseDirectory.ToString() + "/Templates//" + pathName;
        using (StreamReader reader = new StreamReader(Path, Encoding.Default))
        {
            builder.Append(reader.ReadToEnd());
            reader.Close();
        }
        this.Title.Text = pathName;
        this.txtContent.Text = builder.ToString();
        this.ViewState["strPath"] = Path;
    }

    //private void UnitBind()
    //{
    //    DataSet ds = new DataSet();
    //    ds.ReadXml(@Server.MapPath("~/xml/Label.xml"));
    //    this.ModeLabel.DataSource = ds.Tables[0];
    //    this.ModeLabel.DataTextField = ds.Tables[0].Columns[1].ToString();
    //    this.ModeLabel.DataValueField = ds.Tables[0].Columns[0].ToString();
    //    this.ModeLabel.DataBind();
    //}


    protected void dropSystemLable_SelectedIndexChanged(object sender, EventArgs e)
    {
        int TypeID=int.Parse(dropSystemLable.SelectedValue);
        //ISystemLable RSystem = new RSystemLable();
        //DataTable dt = RSystem.GetDataTable(TypeID);
        //lstSystemLable.DataSource = dt.DefaultView;
        //lstSystemLable.DataTextField = "Remarks";
        //lstSystemLable.DataValueField = "Name";
        //lstSystemLable.DataBind();
        SystemLableBind(TypeID);
    }
    protected void dropUserLable_SelectedIndexChanged(object sender, EventArgs e)
    {
        int TypeID = int.Parse(dropUserLable.SelectedValue);
        IUserLable RUser = new RUserLable();
        DataTable dt = RUser.GetDataTable(TypeID);
        lstSystemLable.DataSource = dt.DefaultView;
        lstSystemLable.DataTextField = "Remarks";
        lstSystemLable.DataValueField = "LableName";
        lstSystemLable.DataBind();
       
    }

    /// <summary>
    /// 保存修改
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {

        System.IO.File.WriteAllText(this.ViewState["strPath"].ToString(), this.txtContent.Text, Encoding.Default);
        Response.Redirect("TemplateManage.aspx");
    }
}
