﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class admin_Templates_TemplateManage : Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Template", "A1");
        BuildDynaControl();
    }


    string CurrentPath
    {
        get
        {
            string path = this.ViewState["CurrentPath"] as string;
            if (path == null)
                path = "";
            return path;
        }
        set{ this.ViewState["CurrentPath"] = value;}
    }

    /// <summary>
    /// 特定的用于加载动态控件的方法
    /// </summary>
    private void BuildDynaControl()
    {
        if (!this.IsPostBack)
        {
            BuildDirList();
        }
        else
        {
            // 子文件夹
            System.Collections.ArrayList list = this.ViewState["DirList"]
                as System.Collections.ArrayList;
            // 文件
            System.Collections.ArrayList filelist = this.ViewState["FileList"]
                as System.Collections.ArrayList;

            list.AddRange(filelist);

            foreach (Pair pair in list)
            {
                //Control ctl = null;
                ImageButton ib = new ImageButton();
                string id = "Btn";
                switch ((string)pair.First)
                {
                    case "CheckBox":
                        //ImageButton ib = new ImageButton();
                        ib.Click += new ImageClickEventHandler(ib_Click);
                        id += pair.Second as string;
                        ib.ID = id;
                        break;
                    case "EditBox":
                        
                        ib.Click += new ImageClickEventHandler(ib_Edit);
                        id += pair.Second as string;
                        ib.ID = id;
                        break;
                }

                TableRow tr = new TableRow();
               
                this.TblDirList.Rows.Add(tr);
                TableCell tc = new TableCell();
                tr.Cells.Add(tc);

                //tc.Controls.Add(ctl);
                tc.Controls.Add(ib);
            }

        }
    }




    /// <summary>
    /// 创建目录列表 
    /// </summary>
    private void BuildDirList()
    {
        string ActualPath = AppDomain.CurrentDomain.BaseDirectory.ToString() + "/templates/";
        // 清除原有的行
        this.TblDirList.Rows.Clear();

        // 添加表格的标题
        TableHeaderRow tr = new TableHeaderRow();
        //TableRow tr = new TableRow();
        tr.CssClass = "header";
        this.TblDirList.Rows.Add(tr);

        // 添加五列标题
        TableHeaderCell iCell = new TableHeaderCell();
        //TableCell iconCell = new TableCell();
        iCell.CssClass = "th20 tou";
        iCell.Text = "选择";
        tr.Cells.Add(iCell);



        TableHeaderCell iconCell = new TableHeaderCell();
        //TableCell iconCell = new TableCell();
        iconCell.Text = "名称";
        tr.Cells.Add(iconCell);

        TableHeaderCell sizeCell = new TableHeaderCell();
        //TableCell sizeCell = new TableCell();
        sizeCell.Text = "大小";
        sizeCell.CssClass = "th80";
        tr.Cells.Add(sizeCell);

        TableHeaderCell createCell = new TableHeaderCell();
        //TableCell createCell = new TableCell();
        createCell.Text = "创建日期";
        createCell.CssClass = "th80";
        tr.Cells.Add(createCell);

        TableHeaderCell modifyCell = new TableHeaderCell();
        //TableCell modifyCell = new TableCell();
        modifyCell.CssClass = "th80";
        modifyCell.Text = "修改日期";
        tr.Cells.Add(modifyCell);

        System.Collections.ArrayList list = new ArrayList();

        // 取得子目录
        string[] dirs = System.IO.Directory.GetDirectories(ActualPath+this.CurrentPath);
        BuildTable(true, list, dirs);
        this.ViewState["DirList"] = list;

        // 取得文件列表
        System.Collections.ArrayList filelist = new ArrayList();
        string[] files = System.IO.Directory.GetFiles(ActualPath + this.CurrentPath);
        BuildTable(false, filelist, files);
        this.ViewState["FileList"] = filelist;

        // 显示当前目录
        // this.LblPath.Text = this.CurrentPath;

        TableHeaderCell editCell = new TableHeaderCell();
        editCell.CssClass = "th80";
        editCell.Visible = false;
        tr.Cells.Add(editCell);
        editCell.Text = "管理";

    }



    /// <summary>
    /// 
    /// </summary>
    /// <param name="isDir">目录还是文件</param>
    /// <param name="list"></param>
    /// <param name="dirs"></param>
    private void BuildTable(bool isDir, System.Collections.ArrayList list, string[] dirs)
    {

        foreach (string dir in dirs)
        {
            // 取得目录名
            string shortdirname = System.IO.Path.GetFileName(dir);
            System.Web.UI.WebControls.Label lblName = new System.Web.UI.WebControls.Label();
            lblName.Text = shortdirname;
            lblName.ID = shortdirname;
            
            Pair pair =isDir? new Pair("CheckBox", lblName.ID):new Pair("EditBox", lblName.ID);
            list.Add(pair);

            // 创建一行
            TableRow tr = new TableRow();
            tr.Attributes.Add("onMouseOver", "SetNewColor(this);");
            tr.Attributes.Add("onMouseOut", "SetOldColor(this);");
            this.TblDirList.Rows.Add(tr);

            // 创建图标格
            TableCell iconCell = new TableCell();
            Control iconCtl = null;
            if (isDir)          // 目录
            {
                iconCtl = new ImageButton();
                iconCtl.ID = "Btn" + shortdirname;      // 回发的控件一定要有ID
                ((ImageButton)iconCtl).Click += new ImageClickEventHandler(ib_Click);
                ((ImageButton)iconCtl).ImageUrl = "../images/folder.gif";
            }
            else　　　　　　　　// 文件
            {
                iconCtl = new ImageButton();
                iconCtl.ID = "Btn" + shortdirname;      // 回发的控件一定要有ID
                ((ImageButton)iconCtl).Click += new ImageClickEventHandler(ib_Edit);
                ((ImageButton)iconCtl).ImageUrl = "../images/file.gif";

            }
            iconCell.Controls.Add(iconCtl);
            tr.Cells.Add(iconCell);

            // 创建名字格
            TableCell nameCell = new TableCell();
            nameCell.CssClass = "left2";
            nameCell.HorizontalAlign = HorizontalAlign.Left;
            // 复选框放入表格中
            //nameCell.Controls.Add(cb);
            nameCell.Controls.Add(lblName);
            tr.Cells.Add(nameCell);

            // 尺寸
            TableCell sizeCell = new TableCell();
            tr.Cells.Add(sizeCell);
            if (!isDir)   // 文件计算大小
            {
                // 创建文件的实例
                System.IO.FileInfo fi = new System.IO.FileInfo(dir);
                double length = fi.Length;
                string lengthString = null;
                if (length > 1024 * 1024)
                {
                    lengthString = String.Format("{0:f}MB", Convert.ToInt32(length) / 1024 / 1024);
                }
                else if (length > 1024)
                {
                    lengthString = String.Format("{0}KB", Convert.ToInt32(length) / 1024);
                }
                else if (length > 0)
                {
                    lengthString = "1KB";
                }
                else
                {
                    lengthString = "0KB";
                }
                sizeCell.Text = lengthString;
            }
            else
            { 
   
            }
            // 创建日期
            TableCell createCell = new TableCell();
            tr.Cells.Add(createCell);
            createCell.Text = System.IO.File.GetCreationTime(dir).ToShortDateString();

            // 修改日期
            TableCell modifyCell = new TableCell();
            tr.Cells.Add(modifyCell);
            modifyCell.Text = System.IO.File.GetLastWriteTime(dir).ToShortDateString();

            TableCell editCell = new TableCell();
            editCell.Visible = false;
            tr.Cells.Add(editCell);
            LinkButton lnkEdit = new LinkButton();
            lnkEdit.Text = "编辑";
            lnkEdit.Enabled = false;
            lnkEdit.Visible = false;
            editCell.Controls.Add(lnkEdit);
        }
    }



    void ib_Click(object sender, ImageClickEventArgs e)
    {
        // 改变当前的目录
        // 取得进入的子文件夹的名字
        // sender 就是触发事件的对象
        ImageButton ib = sender as ImageButton;
        string subpath = ib.ID.Substring(3);
        // 计算出现在的 Path
        string currPath = System.IO.Path.Combine(this.CurrentPath, subpath);
        // 通过属性将当前的目录保存到视图状态中
        // 以便于在下次的请求中，可以保持目录
        this.CurrentPath = currPath;
        this.BuildDirList();

    }


    void ib_Edit(object sender, ImageClickEventArgs e)
    {
        // 改变当前的目录
        // 取得进入的子文件夹的名字
        // sender 就是触发事件的对象
        ImageButton ib = sender as ImageButton;
        string subpath = ib.ID.Substring(3);
        // 计算出现在的 Path
        string currPath = System.IO.Path.Combine(this.CurrentPath, subpath);
        // 通过属性将当前的目录保存到视图状态中
        // 以便于在下次的请求中，可以保持目录
        this.CurrentPath = currPath;
        //this.BuildDirList();
        Response.Redirect("TemplateEdit.aspx?MD=" + currPath);
    }
}
