﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UserInfo;
using Base;

public partial class Admin_Trade_FastMemberAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "A1");
    }

    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            RUserInfo RUser = new RUserInfo();
            int UserID = RUser.CheckCompanyName(txtCompanyName.Text.Trim());
            if (UserID != 0)
            {
                ShowMessage("已存在该会员!转向快速发布求购信息!", "Trade/FastPurchaseAdd.aspx?UserID=" + UserID);
            }
            else
            {
                TUserInfo TUser = new TUserInfo();
                TUser.LoginName = txtLoginName.Text;
                TUser.Password = txtPassword.Text.Trim();
                TUser.Email = txtEmail.Text.Trim();
                TUser.CompanyName = txtCompanyName.Text.Trim();
                int UID = RUser.CreateUser(TUser);
                if (UID != 0)
                {
                    Response.Redirect("FastPurchaseAdd.aspx?UserID=" + UID);
                }
            }
        }
        catch (Exception Ex)
        {
            ShowMessage("添加失败!");
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtCompanyName.Text = "";
        txtEmail.Text = "";
        txtLoginName.Text = "";
        txtPassword.Text = "";
        txtPassword2.Text = "";
    }
}
