﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using Corporation.Product;

public partial class Member_ProType_ProTypeList: nspBase.MemberBasePge
{

    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckCookies())
        {
            if (!IsPostBack)
            {
                Bind();
            }
        }
        else
            Response.Redirect("../../Login/Login.aspx");
    }
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "return confirm('您确认要删除吗？')");
        int userid = int.Parse(GetCookie("UserID").ToString());
        if (userid > 0)
        {
            int PageIndex = 0;
            if (HttpContext.Current.Request.QueryString["page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"].ToString());
            if (PageIndex <= 0) PageIndex = 1;
            string strWhere = "UserID=" + userid;
            DataTable dt = PageList.GetDataTable(strWhere, "C_ProType", 0, "Sequence", "*", 10, PageIndex, 0);
            dlstProType.DataSource = dt.DefaultView;
            dlstProType.DataBind();
            this.Pagin.Text = PageList.GoToPager(PageIndex, 10, "ProTypeList.aspx?&page", strWhere, "C_ProType");
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            IProType RPro = new RProType();
            TProType TPro = new TProType();
            int userid = int.Parse(GetCookie("UserID").ToString());
            TPro.UserID = userid;
            TPro.Name =Base.GetRequest.Filter(TxtProTypeName.Text);
            TPro.AddDate = DateTime.Now;
            RPro.Insert(TPro);
            ShowMessage("自定义分类添加成功！", "ProType/ProTypeList.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("添加自定义分类添加失败，请重新添加！", "ProType/ProTypeList.aspx");
        }

    }

    protected void dlstProType_CancelCommand(object source, DataListCommandEventArgs e)
    {
        dlstProType.EditItemIndex = -1;
        Bind();
    }
    protected void dlstProType_DeleteCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstProType.DataKeys[e.Item.ItemIndex]);
        TProType TProType = new TProType();
        TProType.ID = id;
        IProType RProType = new RProType();
        RProType.Delete(id);
        Bind();
    }
    protected void dlstProType_EditCommand(object source, DataListCommandEventArgs e)
    {
        dlstProType.EditItemIndex = e.Item.ItemIndex;
        Bind();
    }
    protected void dlstProType_UpdateCommand(object source, DataListCommandEventArgs e)
    {
        int id = Convert.ToInt32(dlstProType.DataKeys[e.Item.ItemIndex]);
        string name = ((TextBox)e.Item.FindControl("txtName")).Text;
        string sequence = ((TextBox)e.Item.FindControl("txtSequence")).Text.Trim();
        if (sequence == "")
            sequence = "0";
        TProType TProType = new TProType();
        TProType.ID = id;
        TProType.Name = name;
        TProType.Sequence = int.Parse(sequence);
        IProType RProType = new RProType();
        RProType.Update(TProType);
        dlstProType.EditItemIndex = -1;
        Bind();
    }

    //排序
    protected void LinkButton1_Click(object sender, EventArgs e)
    {
        foreach (DataListItem li in this.dlstProType.Items)
        {
            int txtd = 0;
            TextBox txt = li.FindControl("txtSequence") as TextBox;
            System.Web.UI.WebControls.Label lbid = li.FindControl("Lb_id") as System.Web.UI.WebControls.Label;
            if (txt.Text.Trim() != "")
                txtd = Convert.ToInt32(txt.Text.ToString());
            else
                txtd = 0;
            int lbxid = Convert.ToInt32(lbid.Text.ToString());
            IProType RProType = new RProType();
            RProType.UpdateSequence(txtd, lbxid);
        }
        Bind();
    }

    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= dlstProType.Items.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)dlstProType.Items[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int UserID = Convert.ToInt32(dlstProType.DataKeys[i]);
                IProType RProType = new RProType();
                int m = RProType.Delete(UserID);
            }
        }
        Bind();
    }
}
