﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspProduct;
using Base;

public partial class Admin_Trade_ProductAdd : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            clsTProduct pro = new clsTProduct();
            if (txtName.Text != string.Empty)
            {
                pro.Name = txtName.Text;
            }
            else
            {
                ShowMessage("产品名称不能为空");
                return;
            }
            string myvalue = "";
            myvalue += Request.Form["SortB"];
            if (string.IsNullOrEmpty(Request.Form["SortM"]))
                myvalue += ',' + Request.Form["SortM"];
            if (string.IsNullOrEmpty(Request.Form["SortS"]))
                myvalue += ',' + Request.Form["SortS"];
            if (myvalue != ",,")
            {
                pro.TypeId = myvalue;
            }
            else
            {
                ShowMessage("请选择产品类型");
                return;
            }
            if (txtKeyWord.Text != "")
            {
                pro.KeyWord = txtKeyWord.Text;
            }
            else
                pro.KeyWord = "";
            if (ImgUrl1.Value != string.Empty)
            {
                pro.Picture = ImgUrl1.Value;
            }
            else
                pro.Picture = "";
            if (Detail.Value != string.Empty)
            {
                string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
                Temp = GetRequest.WipeScript(Temp);
                pro.Detail = Temp;
            }
            else
                pro.Detail = "";
            if (txtAddDate.Text != "")
            {
                if (GetRequest.isDataTime(txtAddDate.Text))
                    pro.AddDate = Convert.ToDateTime(txtAddDate.Text);
                else
                    pro.AddDate = DateTime.Now;
            }
            else
                pro.AddDate = DateTime.Now;
            if (txtPrice.Text != "")
            {
                if (GetRequest.isProce(txtPrice.Text))
                    pro.Price = float.Parse(txtPrice.Text);
                else
                    pro.Price = 0;
            }
            else
                pro.Price = 0;
            clsIProduct Rpro = new clsRProduct();
            Rpro.Insert(pro);
            ShowMessage("产品信息添加成功", "Trade/ProductManage.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("产品信息添加失败", "Trade/ProductManage.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        txtName.Text = string.Empty;
        txtKeyWord.Text = string.Empty;
        txtAddDate.Text = string.Empty;
        Detail.Value = string.Empty;
        ImgUrl1.Value = string.Empty;
        ImgUrl.Src = string.Empty;
    }
}
