﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using nspProduct;
using Base;

public partial class Admin_Trade_ProductEdit :BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request["ID"]!=null&&Request["ID"]!="")
        {
            clsIProduct Rpro = new clsRProduct();
            clsTProduct Tpro=Rpro.GetItems(int.Parse(Request["ID"]));
            txtName.Text = Tpro.Name;
            txtKeyWord.Text = Tpro.KeyWord;
            Detail.Value = Tpro.Detail;
            txtAddDate.Text = Tpro.AddDate.ToString();
            ImgUrl1.Value = Tpro.Picture;
            if (Tpro.Picture != "")
                ImgUrl.Src = Tpro.Picture;
            txtPrice.Text = Tpro.Price+"";
            if (Tpro.TypeId != null)
            {
                string[] str = Tpro.TypeId.Split(new char[] { ',' });
                for (int i = 0; i < str.Length; i++)
                {
                    if (i == 0)
                        this.txtSortB.Value = str[i];
                    else if (i == 1)
                        this.txtSortM.Value = str[i];
                    else
                        this.txtSortS.Value = str[i];
                }
            }
            
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            clsTProduct pro = new clsTProduct();
            if (Request["ID"] != null)
            {
                pro.ID =Convert.ToInt32(Request["ID"]);
            }
            if (txtName.Text != string.Empty)
            {
                pro.Name = txtName.Text;
            }
            else
            {
                ShowMessage("产品名称不能为空");
                return;
            }
            string myvalue = "";
            myvalue += Request.Form["SortB"];
            myvalue += ',' + Request.Form["SortM"];
            myvalue += ',' + Request.Form["SortS"];
            if (myvalue != ",,")
            {
                pro.TypeId = myvalue;
            }
            else
            {
                ShowMessage("请选择产品类型");
                return;
            }
            if (txtKeyWord.Text != "")
            {
                pro.KeyWord = txtKeyWord.Text;
            }
            else
                pro.KeyWord = "";
            if (ImgUrl1.Value != string.Empty)
            {
                pro.Picture = ImgUrl1.Value;
            }
            else
                pro.Picture = "";
            if (Detail.Value != string.Empty)
            {
                string Temp = GetRequest.RemoveHTMLForEditor(Detail.Value);
                Temp = GetRequest.WipeScript(Temp);
                pro.Detail = Temp;
            }
            else
                pro.Detail = "";
            if (txtAddDate.Text != "")
            {
                if (GetRequest.isDataTime(txtAddDate.Text))
                    pro.AddDate = Convert.ToDateTime(txtAddDate.Text);
                else
                    pro.AddDate = DateTime.Now;
            }
            else
                pro.AddDate = DateTime.Now;
            if (txtPrice.Text != "")
            {
                if (GetRequest.isProce(txtPrice.Text))
                    pro.Price = float.Parse(txtPrice.Text);
                else
                    pro.Price = 0;
            }
            else
                pro.Price = 0;
            clsIProduct Rpro = new clsRProduct();
            Rpro.Update(pro);
            ShowMessage("产品信息修改成功", "Trade/ProductManage.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("产品信息修改失败", "Trade/ProductManage.aspx");
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("ProductManage.aspx");
    }
}
