﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using nspProduct;

public partial class Admin_Trade_ProductManage : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        int id = int.Parse(e.CommandArgument.ToString());
        clsIProduct Rpro = new clsRProduct();
        Rpro.Delete(id);
        Bind();
    }  
   
    #region 绑定数据方法
    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        string strWhere = "";
        PageNo1.Table = "W_Products";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "W_Products.*";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false; 
            gvProducts.DataSource = dt.DefaultView;
            gvProducts.DataBind();
        }
        else {
            PageNo1.Where = "";
            Session["strWhere"] = "";
            PageNo1.Pageindex = 1;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            gvProducts.DataSource = dt.DefaultView;
            gvProducts.DataBind();
        }
    }
    #endregion   

    /// <summary>
    /// 删除
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= gvProducts.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)gvProducts.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int ID = Convert.ToInt32(gvProducts.DataKeys[i].Value);
                clsIProduct Rpro = new clsRProduct();
                int m = Rpro.Delete(ID);
            }
        }
        Bind();
    }
    protected void lbtnUpdateRecommend_Command(object sender, CommandEventArgs e)
    {
      
    }

    /// <summary>
    /// 搜索
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "";
        string uName = Base.GetRequest.Filter(txtName.Text.Trim());
        if (uName != "")
            strWhere += "[Name] like '%" + uName + "%'";
        Session["strWhere"] = strWhere;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl);
        Response.End();

      //  pbind(strWhere, 1, "t=" + uName + "&");
    } 
   
    protected void gvProducts_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType==DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver","SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");
        }
    }
    public string GetNewTitle(string Title, string strID)
    {
        string Restr = "<a href=\"" + Base.BasePage.Config.WebURL + "Product/Detail.aspx?id=" + strID + "\" target=\"blank\">" + Title + "</a>";
        return Restr;
    }
}
