﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Product;
using Base;
using Corporation.Product;

public partial class admin_Trade_PurchaseView : BasePage
{
    public static int strVerify;
    public static int strId;
    RProType ProType = new RProType();
    protected void Page_Load(object sender, EventArgs e)
    {

        try
        {
            if (!CheckRights("system", "A1"))
            {
                HandleErr("您没有对该功能的操作权限", "index_Center.aspx", "1");
                return;
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
        if (!IsPostBack)
        {
            UnitBind();
            PersonInfoBind();
            Bind();

        }

    }
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        strId = id;
        IPurchase RPur = new RPurchase();
        TPurchase TPur = RPur.GateItem(id);
        strVerify = TPur.Verify;
        this.txtName.Text = TPur.Name;
        this.txtKey.Text = TPur.Key;

        this.txtSortB.Value = TPur.IndType;
        this.txtContent.Value = TPur.Info;
        if (TPur.Picture_1 == "")
        {
            this.ImgUrl1.Value = "../../Images/System/wutu.gif";
            this.ImgUrl.Src = "../../Images/System/wutu.gif";
        }
        else
        {
            this.ImgUrl1.Value = TPur.Picture_1;
            this.ImgUrl.Src = TPur.Picture_1;
        }
        this.txtBrand.Text = TPur.Brand;
        this.txtModel.Text = TPur.Model;
        TimeSpan time = new TimeSpan(TPur.EndDate.Ticks - TPur.StartDate.Ticks);
        this.RadioTime.SelectedValue = time.Days.ToString();
        this.dropUnit.SelectedValue = TPur.Unit;
        this.txtCount.Text = TPur.Count.ToString();
        this.txtPrice.Text = TPur.Price.ToString();
        if (TPur.IndType != null)
        {
            string[] str = TPur.IndType.Split(new char[] { ',' });
            for (int i = 0; i < str.Length; i++)
            {
                if (i == 0)
                    this.txtSortB.Value = str[i];
                else if (i == 1)
                    this.txtSortM.Value = str[i];
                else
                    this.txtSortS.Value = str[i];
            }
        }
    }
    private void PersonInfoBind()
    {
        int userid = int.Parse(Request.QueryString["UserID"].ToString());
        DataTable tbuserinfo = ProType.GetPersonInfo(userid);
        if (tbuserinfo.Rows.Count != 0)
        {
            this.UserName.Text = tbuserinfo.Rows[0]["LinkName"].ToString() + "(" + tbuserinfo.Rows[0]["sex"].ToString() + ")";
            this.UserTelephone.Text = tbuserinfo.Rows[0]["Tel_International"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_DistrictNumber"].ToString() + " -" + " " + tbuserinfo.Rows[0]["Tel_Telephone"].ToString();
            this.UserChuanzhen.Text = tbuserinfo.Rows[0]["qq"].ToString();
            this.CompanyName.Text = tbuserinfo.Rows[0]["CompanyName"].ToString();
            this.Email.Text = tbuserinfo.Rows[0]["Email"].ToString();
           
        }
    }
    private void UnitBind()
    {
        DataSet ds = new DataSet();
        ds.ReadXml(@Server.MapPath("~/xml/UnitPrice.xml"));
        dropUnit.DataSource = ds.Tables[0];
        dropUnit.DataTextField = ds.Tables[0].Columns[1].ToString();
        dropUnit.DataValueField = ds.Tables[0].Columns[0].ToString();
        dropUnit.DataBind();
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string myValue = "";
            myValue += Request.Form["SortB"];
            if (Request.Form["SortM"]!=null)
                myValue += ',' + Request.Form["SortM"];
            if (Request.Form["SortS"]!=null)
               myValue += ',' + Request.Form["SortS"];
            
            int id = int.Parse(Request.QueryString["ID"].ToString());
            TPurchase TPur = new TPurchase();
            TPur.ID = id;
            TPur.IndType = myValue;
            TPur.Name = this.txtName.Text;
            if (!string.IsNullOrEmpty(this.txtKey.Text))
            {
                ArrayList array = new ArrayList();
                String newvalue = this.txtKey.Text;
                String oldvalue = newvalue.Replace("，", ",");
                String[] arry = oldvalue.Split(',');//拿逗号隔开后的字符串
                for (int i = 0; i < arry.Length; i++)
                {
                    if (array.Contains(arry[i]) == false)//判断 要拆分的字符串 中是否已经存在于这个ArrayList中   
                    {
                        array.Add(arry[i]);//不存在则添加进ArrayList   
                    }
                }
                TPur.Key = Server.HtmlEncode(String.Join(",", (string[])array.ToArray(typeof(string))));//在指定 String 数组的每个元素之间串联指定的分隔符 String，从而产生单个串联的字符串
            }
            string temp = GetRequest.WipeScript(this.txtContent.Value);
            TPur.Info = temp;
            TPur.Thumbnail = this.ImgUrl1.Value;
            TPur.Picture_1 = this.ImgUrl1.Value;
            TPur.StartDate = Convert.ToDateTime(DateTime.Now.ToShortDateString());
            TPur.EndDate = DateTime.Now.AddDays(Convert.ToDouble(this.RadioTime.SelectedValue));
            TPur.Brand = this.txtBrand.Text;
            TPur.Model = this.txtModel.Text;
            TPur.Unit = dropUnit.SelectedValue;
            if (GetRequest.isNum(txtCount.Text))
                TPur.Count = int.Parse(txtCount.Text);
            else
                TPur.Count = 0;
            if (GetRequest.isProce(txtPrice.Text))
                TPur.Price =Convert.ToDouble(txtPrice.Text);
            else
                TPur.Price = 0;
            IPurchase Rpur = new RPurchase();
            Rpur.Update(TPur);
            if (Request.QueryString["ID"] != null)
            {
                Solely.Other.UpOnlyDate("C_Purchase", "Verify=" + strVerify + "", "id in(" + strId + ")");
            }
            ShowMessage("恭喜您，商机发布成功！", "trade/PurchaseManage.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("商机发布失败！", "trade/PurchaseManage.aspx");
        }


    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("PurchaseManage.aspx");
    }
    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
            return Convert.ToDateTime(dateStr).ToShortDateString();
        else
            return String.Empty;
    }
}
