﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Product;
using Base;
using UserInfo;

public partial class admin_Trade_SupplyManage : BasePage
{

    protected void Page_Load(object sender, EventArgs e)
    {

        CheckRights("column", "A1");
        try
        {
            if (!IsPostBack)
            {
                BindVipGrade();
                Bind();
            }
        }
        catch (Exception ex)
        {
            HttpContext.Current.Response.Write(ex.Message);
        }
    }
    


    private void Bind()
    {
        btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = " C_Supply.UserID=U_UserInfo.UserID";
        int LoginGrade = Convert.ToInt32(txtGrade.SelectedValue.ToString());
        PageNo1.Strurl = strURl;
        PageNo1.Table = "C_Supply,U_UserInfo inner join U_VipGrade on(U_UserInfo.GradeID=U_VipGrade.id)";
        PageNo1.FldName = "AddDate";
        PageNo1.StrGetFields = "C_Supply.*,U_UserInfo.LoginName";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != null && Request.QueryString["page"] != "")
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
            {
                strWhere = Session["strWhere"].ToString();
            }
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count > 0)
            {
                grdSupply.DataSource = dt.DefaultView;
                grdSupply.DataBind();
                this.grdSupply.Visible = true;
                this.lblMessage.Visible = false;
            }
            else
            {
                this.lblMessage.Text = "<font color='red'>暂无商机信息！</font>";
                this.lblMessage.Visible = true;
                this.grdSupply.Visible = false;
            }
        }
        else {
            string TitleName = txtTitleName.Text.Trim();
           
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label2.CssClass = "pl";
                        strWhere += " and C_Supply.Verify=1";
                        break;
                    case "2":
                        strWhere += " and C_Supply.Verify=3";
                        this.Label3.CssClass = "pl";
                        break;
                    case "3":
                        strWhere += " and C_Supply.Recommend=1";
                        this.Label4.CssClass = "pl";
                        break;
                    default:
                        this.Label1.CssClass = "pl";
                        break;
                }
            }
            else
            {
                this.Label1.CssClass = "pl";
            }

            if (TitleName != "")    //商机名称
                strWhere += " and C_Supply.Name like '%" + Base.GetRequest.Filter(TitleName) + "%'";
            if (LoginGrade != 0)
            {
                strWhere += " and GradeID = " + LoginGrade + "";
            }
            Session["strWhere"] = strWhere;
            PageNo1.Where = strWhere;
            PageNo1.Pageindex = 1;           
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.Rows.Count > 0)
            {
                grdSupply.DataSource = dt.DefaultView;
                grdSupply.DataBind();
                this.grdSupply.Visible = true;
                this.lblMessage.Visible = false;
            }
            else
            {
                this.lblMessage.Text = "<font color='red'>暂无商机信息！</font>";
                this.lblMessage.Visible = true;
                this.grdSupply.Visible = false;
            }
        }
    }

    private void BindVipGrade()
    {
        RUserInfo Gradetype = new RUserInfo();
        DataTable dt = Gradetype.GetDataType("U_VipGrade");
        if (dt.Rows.Count == 0)
            return;
        txtGrade.DataSource = dt.DefaultView;
        txtGrade.DataValueField = "ID";
        txtGrade.DataTextField = "Name";
        txtGrade.DataBind();
        txtGrade.Items.Insert(0, new ListItem("全部", "0"));
    }

    /// <summary>
    ///  删除商业信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdSupply.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSupply.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                int ID = Convert.ToInt32(grdSupply.DataKeys[i].Value);
                ISupply RUser = new RSupply();
                int m = RUser.Delete(ID);
            }
        }
        Bind();
    }


    /// <summary>
    ///  审核商业信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnUpdate_Command(object sender, CommandEventArgs e)
    {
        TSupply TSup = new TSupply();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TSup.ID = int.Parse(Content.Substring(0, index));
        TSup.Verify = int.Parse(Content.Substring(index + 1));
        ISupply RSup = new RSupply();
        RSup.UpdateVerify(TSup);
        Bind();
    }


    /// <summary>
    /// 搜索该会员发布的信息
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnbCheckUser_Command(object sender, CommandEventArgs e)
    {
        string strWhere = "C_Supply.UserID=U_UserInfo.UserID";
        string Content = e.CommandName.ToString();
        strWhere += " and  C_Supply.UserID=" + Content;
        Session["strWhere"] = strWhere;
        string strURl1 = Request.RawUrl;
        strURl1 = strURl1.Substring(0, strURl1.IndexOf(".aspx")) + ".aspx?page=1";
        Response.Redirect(strURl1);
        Response.End();
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lbtnUpdateRecommend_Command(object sender, CommandEventArgs e)
    {
        TSupply TSup = new TSupply();
        string Content = e.CommandArgument.ToString();
        int index = Content.IndexOf("|");
        if (index < -1 || index + 1 > Content.Length)
            return;

        TSup.ID = int.Parse(Content.Substring(0, index));
        TSup.Recommend = Convert.ToBoolean(Content.Substring(index + 1));
        ISupply RSup = new RSupply();
        RSup.UpdateRecommend(TSup);
        Bind();
    }


    protected void btnSearch_Click(object sender, EventArgs e)
    {
        string strWhere = "C_Supply.UserID=U_UserInfo.UserID";
        string TitleName = txtTitleName.Text.Trim();
        int LoginGrade = Convert.ToInt32(Base.GetRequest.Filter(txtGrade.SelectedValue));
        if (TitleName != "")
            strWhere += " and C_Supply.Name like '%" + Base.GetRequest.Filter(TitleName) + "%'";
        if (LoginGrade != 0)
        {
            strWhere += " and GradeID = " + LoginGrade + "";
        }
        else
        {
            strWhere += "";
        }
        Session["strWhere"] = strWhere;
        Bind();
    }


    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        try
        {
            int id = int.Parse(e.CommandArgument.ToString());
            ISupply RUser = new RSupply();
            int m = RUser.Delete(id);
            Bind();
        }
        catch
        { }
    }


    protected void grdSuppy_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");
        }
    }


    /// <summary>
    /// 审核通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdSupply.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSupply.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
                strID += "," + Convert.ToInt32(grdSupply.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Trade/SupplyManage.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("C_Supply", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {  
            Bind();
            
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Trade/SupplyManage.aspx");
        }

    }


    /// <summary>
    /// 审核未通过
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= grdSupply.Rows.Count - 1; i++)
        {
            CheckBox cbox = (CheckBox)grdSupply.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {
               strID += ","+ Convert.ToInt32(grdSupply.DataKeys[i].Value);
            }
        }

        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Trade/SupplyManage.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("C_Supply", "Verify=2", "id in(" + strID.Substring(1) + ")"))
        {
            
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Trade/SupplyManage.aspx");
        }
    }


    /// <summary>
    /// 绑定审核状态
    /// </summary>
    /// <param name="strVerify"></param>
    /// <returns></returns>
    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "2")
        {
            return "未通过";
        }
        else
        {
            return "未审";
        }
    }

    public string GetNewTitle(string Title, string strID)
    {
        string Restr = "<a href=\"" + Base.BasePage.Config.WebURL + "Supply/Detail.aspx?id=" + strID + "\" target=\"blank\">" + Title + "</a>";
        return Restr;
    }
}
