﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="UsersProductManage.aspx.cs"
    Inherits="Member_Trade_ProductManage" %>

<%@ Register Src="../../Control/PageNo.ascx" TagName="PageNo" TagPrefix="uc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<title>管理用户产品信息</title>
<link href="../skin/Style.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="../../js/jquery.js"></script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="itemtitle">
            产品管理
        </div>
         <div class="itemtitle_tect">
            <ul>
                <li>通过供应信息管理，您可以进行编辑信息审核、推荐、修改和删除等操作；</li>
            </ul>
        </div>
        <div class="clr">
        </div>
        <div class="partition">
            <div class="Option">
                <asp:Label ID="Label5" runat="server"><strong>快捷操作</strong></asp:Label>
                <asp:Label ID="Label1" runat="server"><a href="?v=0">所有信息</a></asp:Label>
                <asp:Label ID="Label2" runat="server"><a href="?v=1">产品已审核</a></asp:Label>
                <asp:Label ID="Label3" runat="server"><a href="?v=2">产品未审核</a></asp:Label>
                <asp:Label ID="Label4" runat="server"><a href="?v=3">请求靠前</a></asp:Label>
                <asp:Label ID="Label6" runat="server"><a href="?v=4">已请求靠前</a></asp:Label>
            </div>
        </div>
        <div class="talbe_border">
            <asp:GridView ID="gvProducts" runat="server" CssClass="talbe_list" CellPadding="0" GridLines="None"
                AutoGenerateColumns="False" DataKeyNames="ID" OnRowDataBound="gvProducts_RowDataBound">
                <Columns>
                    <asp:TemplateField>
                        <ItemTemplate>
                            <asp:CheckBox ID="CheckBox1" runat="server" />
                        </ItemTemplate>
                        <HeaderStyle CssClass="th20 tou" />
                        <ItemStyle CssClass="nolet" />
                    </asp:TemplateField>
                    <asp:TemplateField Visible="False">
                        <ItemTemplate>
                            <asp:Label ID="lblId" runat="server" Text='<%# Eval("ID") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
					 <asp:TemplateField HeaderText="排序">
                        <ItemTemplate>
                            <asp:TextBox ID="TxtSort" runat="server" Text='<%# Eval("Sort") %>' CssClass="i_corp">
                            </asp:TextBox>
                        </ItemTemplate>
                        <ItemStyle CssClass="th20" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="公司名称">
                        <ItemTemplate>
                            <%# Eval("CompanyName") %>
                        </ItemTemplate>
                       <ItemStyle CssClass="left2" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="产品名称">
                        <ItemTemplate>
                            <%# Eval("Name") %>
                        </ItemTemplate>
                        <ItemStyle CssClass="th80" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="是否靠前">
                        <ItemTemplate>
                            <%# DataBinder.Eval(Container.DataItem, "IsTop").ToString()== "True" ? "是" : "否"%>
                        </ItemTemplate>
                        <ItemStyle CssClass="th30" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="要求">
                        <ItemTemplate>
                            <%# Eval("Ask") %>
                        </ItemTemplate>
                        <ItemStyle CssClass="th30" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="有效期至">
                        <ItemTemplate>
                            <asp:Label ID="Label9" runat="server" Text='<%# GetShortDate(Eval("LastDate").ToString()) %>'></asp:Label>
                        </ItemTemplate>
                        <ItemStyle CssClass="th30" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="申请日期">
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# GetShortDate(Eval("AddDate").ToString()) %>'></asp:Label>
                        </ItemTemplate>
                        <ItemStyle CssClass="th30" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="产品审核">
                        <ItemTemplate>
                            <span>
                                <%#  ShowVerify(Eval("Verify").ToString())  %>
                            </span>
                        </ItemTemplate>
                        <ItemStyle CssClass="th30" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <ItemTemplate>
                            <a href='UsersProductsEdit.aspx?ID=<%# Eval("ID") %>'>编辑</a> | 
                            <asp:LinkButton ID="lbtnDelete" runat="server" CommandArgument='<%# DataBinder.Eval(Container.DataItem, "ID")%>'
                                Font-Underline="false" Text="删除" OnCommand="lbtnDelete_Command" OnClientClick="return confirm('你确定要删除吗?')"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle CssClass="th80" />
                    </asp:TemplateField>
                </Columns>
                <HeaderStyle CssClass="header" />
            </asp:GridView>
            <div class="Paging">
                <p>
                    <uc1:PageNo ID="PageNo1" runat="server" />
                </p>
                <input id="CheckBox2" name="CheckBox2" onclick="SelectAll();" type="checkbox" />全选
                <asp:Button ID="btnDelete" runat="server" Font-Size="9pt" Text="批量删除" CssClass="i_button"
                    OnClientClick="return confirm('你确定要删除吗？')" OnClick="btnDelete_Click" />
                <asp:Button ID="btnSort" runat="server" Font-Size="9pt" Text="排序" CssClass="i_button"
                    OnClick="btnSort_Click" />
                <asp:Button ID="ButEigible" runat="server" Font-Size="9pt" Text="审核通过" CssClass="i_button1"
                    OnClientClick="javascript:return confirm('您确定要让该信息通过审核吗？') " OnClick="ButEigible_Click"  />
                <asp:Button ID="ButDisqualification" runat="server" Font-Size="9pt" Text="审核未通过" CssClass="i_button1"
                    OnClientClick="javascript:return confirm('您确定不让该信息通过审核吗？')" OnClick="ButDisqualification_Click"  />
                <asp:Label ID="lblMessage" runat="server" Visible="false"></asp:Label>
            </div>
        </div>
    </form>
</body>
</html>
