﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Base;
using SqlOperate;
using System.Data.SqlClient;

public partial class Member_Trade_ProductManage : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private int pageSize = 12;//这里设置分页尺寸

    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        string strWhere = "1=1";
        PageNo1.Strurl = strURl;
        PageNo1.Table = " U_UserInfo u inner join W_UsersProducts i on u.UserId=i.UserID inner join W_Products p on p.ID=i.ProductId  ";
        PageNo1.FldName = "i.AddDate";
        PageNo1.StrGetFields = "i.ID,i.IsTop,i.Ask,i.LastDate,u.UserId,u.CompanyName,p.Name,i.Verify,i.sort,i.AddDate";
        PageNo1.PageSize = pageSize;
        if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
                strWhere = Session["strWhere"].ToString();
            PageNo1.Where = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            gvProducts.DataSource = dt.DefaultView;
            gvProducts.DataBind();
            dt.Clear();
            dt.Dispose();
        }
        else
        {
            if (GetRequest.GetQueryStringValue("V") != "")
            {
                switch (GetRequest.GetQueryStringValue("v"))
                {
                    case "1":
                        this.Label2.CssClass = "pl";
                        strWhere += " AND i.Verify<3";
                        break;
                    case "2":
                        strWhere += " AND i.Verify=3";
                        this.Label3.CssClass = "pl";
                        break;
                    case "3":
                        strWhere += " AND i.IsTop=0 AND i.Ask<>''";
                        this.Label4.CssClass = "pl";
                        break;
                    case "4":
                        strWhere += " AND i.IsTop=1";
                        this.Label6.CssClass = "pl";
                        break;
                    default:
                        this.Label1.CssClass = "pl";
                        break;
                }
            }
            PageNo1.Pageindex = 1;
            PageNo1.Where = strWhere;
            Session["strWhere"] = strWhere;
            DataTable dt = PageNo1.BindViewDesc();
            if (dt.DefaultView.Count == 0)
            {
                lblMessage.Visible = true;
                lblMessage.Text = "暂无数据信息";
            }
            else
                lblMessage.Visible = false;
            gvProducts.DataSource = dt.DefaultView;
            gvProducts.DataBind();
            dt.Clear();
            dt.Dispose();
        }
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i < gvProducts.Rows.Count; i++)
        {
            CheckBox chk = (CheckBox)gvProducts.Rows[i].FindControl("CheckBox1");
            if (chk.Checked == true)
            {
                int ID = Convert.ToInt32(gvProducts.DataKeys[i].Value);
                try
                {
                    SqlParameter[] param = new SqlParameter[] 
                    {
                        new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                        new SqlParameter("@strTableName", "W_UsersProducts") 
                    };
                    SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
                }
                catch (Exception ex)
                {
                    ShowMessage(ex.Message);
                }

            }
        }
        Bind();
    }
    protected void btnSort_Click(object sender, EventArgs e)
    {
        foreach (GridViewRow rows in this.gvProducts.Rows)
        {
            TextBox txt = rows.FindControl("txtSort") as TextBox;
            Label iId = rows.FindControl("lblId") as Label;
            int txtd = 0;
            if (txt.Text.ToString() != "")
                txtd = Convert.ToInt32(txt.Text.ToString());
            int id = Convert.ToInt32(iId.Text.ToString());
            try
            {
                SqlParameter[] parms ={ 
                    new SqlParameter("@sort",txtd),
                    new SqlParameter("@Id",id),
                    new SqlParameter("@money",0),
                    new SqlParameter("@date",DateTime.Now)
                 };
                SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "[SP_W_UsersProducts_Update]", parms);
                Bind();
            }
            catch (Exception ex)
            {
                ShowMessage(ex.Message);
            }
        }
        Bind();
    }
    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int ID = int.Parse(e.CommandArgument.ToString());
        try
        {
            SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + ID + ")"), 
                new SqlParameter("@strTableName", "W_UsersProducts") 
            };
            SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
        Bind();
    }

    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
        {
            return Convert.ToDateTime(dateStr).ToShortDateString();
        }
        else
            return string.Empty;
    }
    protected void gvProducts_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this)");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }

    public static string ShowVerify(string strVerify)
    {
        if (strVerify == "1")
        {
            return "通过";
        }
        else if (strVerify == "2")
        {
            return "未通过";
        }
        else if (strVerify == "3")
        {
            return "未审核";
        }
        return "";
    }
    protected void ButEigible_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= gvProducts.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)gvProducts.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                strID += "," + Convert.ToInt32(gvProducts.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Trade/UsersProductManage.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_UsersProducts", "Verify=1", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Trade/UsersProductManage.aspx");
        }
    }
    protected void ButDisqualification_Click(object sender, EventArgs e)
    {
        string strID = "";
        for (int i = 0; i <= gvProducts.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)gvProducts.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                strID += "," + Convert.ToInt32(gvProducts.DataKeys[i].Value);
            }
        }
        if (strID == "")
        {
            Base.BasePage.ShowMessage("您还没有选择信息！", "Trade/UsersProductManage.aspx");
            return;
        }

        if (Solely.Other.UpOnlyDate("W_UsersProducts", "Verify=2", "id in(" + strID.Substring(1) + ")"))
        {
            Bind();
        }
        else
        {
            Base.BasePage.ShowMessage("审核出现错误！", "Trade/UsersProductManage.aspx");
        }
    }
}
