﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using Base;
using SqlOperate;

public partial class Admin_Trade_UsersProductsEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        if (Request["ID"]!=null)
        {
            int id =int.Parse(Request.QueryString["ID"]);
            SqlParameter[] param = new SqlParameter[] 
            { 
                new  SqlParameter("@strSelect","i.ID,i.IsTop,i.Ask,i.LastDate,u.UserId,u.CompanyName,u.LinkName,u.MobilePhone,p.Name,p.Price,i.Verify,i.Money,i.sort,i.AddDate"),
                new SqlParameter("@strwhere", "where i.ID="+Convert.ToInt32(id)),
                new SqlParameter("@strtableName", " U_UserInfo u inner join W_UsersProducts i on u.UserId=i.UserID inner join W_Products p on p.ID=i.ProductId"),
                new SqlParameter("@strOrder", "") 
            };
            DataTable dt = SqlHelper.ExecuteTable(CommandType.StoredProcedure, "SP_SelectByWhere", param);
            if (dt!=null)
            { 
                lblProductName.Text = dt.Rows[0]["Name"].ToString();
                lblPrice.Text = dt.Rows[0]["Price"].ToString();
                lblCompanyName.Text = dt.Rows[0]["CompanyName"].ToString();
                lblUserName.Text = dt.Rows[0]["LinkName"].ToString();
                lblPhone.Text = dt.Rows[0]["MobilePhone"].ToString();
                txtMoney.Text = dt.Rows[0]["Money"].ToString();
                txtAsk.Text = dt.Rows[0]["ask"].ToString();
                if (dt.Rows[0]["LastDate"].ToString() != "" && GetRequest.isDataTime(dt.Rows[0]["LastDate"].ToString()))
                     txtLastDate.Text = DateTime.Parse(dt.Rows[0]["LastDate"].ToString()).ToShortDateString();
                txtSort.Text = dt.Rows[0]["Sort"].ToString();
            }
            
        }
    }
    protected void btnConfim_Click(object sender, EventArgs e)
    {
        int id = 0;
        if (Request["ID"]!=null)
        {
            id =int.Parse(Request.QueryString["ID"]);
        }
        if (txtMoney.Text != "" && txtLastDate.Text != "")
        {
            if (!GetRequest.isProce(txtMoney.Text))
                txtMoney.Text = "0";
            if (!GetRequest.isDataTime(txtLastDate.Text))
                txtLastDate.Text = DateTime.Now.ToString();
            if (!GetRequest.isNum(txtSort.Text))
                txtSort.Text = "0";
            try
            {
                SqlParameter[] parms ={ 
                    new SqlParameter("@date",DateTime.Parse(txtLastDate.Text)),
                    new SqlParameter("@money",float.Parse(txtMoney.Text)),
                    new SqlParameter("@sort",int.Parse(txtSort.Text)),
                    new SqlParameter("@Id",id)
                };
                SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "[SP_W_UsersProducts_Update]", parms);
                ShowMessage("修改成功", "Trade/UsersProductManage.aspx");
            }
            catch (Exception ex)
            {
                ShowMessage("修改失败", "Trade/UsersProductManage.aspx");
            }
           
        }
        else
        {
            ShowMessage("所有选项不能为空");
        }
       
       
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("UsersProductManage.aspx");
    }
}
