﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using SqlOperate;
using Base;

public partial class Admin_Trade_VisitorResquest : BasePage
{
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("column", "E1");
        if (!IsPostBack)
        {
            Bind();
        }
    }
    private void Bind()
    {
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strURl;
        PageNo1.Table = "[W_VisitorRequest] a inner join [W_Products] b on a.ProductId=b.ID";
        PageNo1.FldName = "a.AddDate";
        PageNo1.StrGetFields = "a.*,b.Name";
        PageNo1.PageSize = 12;
        if (Request.QueryString["page"] != null)
        {
            PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
            if (Session["strWhere"] != null)
            {
                PageNo1.Where = Session["strWhere"].ToString();
            }
            else
            {
                PageNo1.Where = "1=1";
            }           
            DataTable table = PageNo1.BindView();
            gvVisitorRequest.DataSource = table.DefaultView;
            gvVisitorRequest.DataBind();
        }
        else
        {
            PageNo1.Pageindex = Pageindex;
            PageNo1.Where = "1=1";           
            DataTable table = PageNo1.BindView();
            gvVisitorRequest.DataSource = table.DefaultView;
            gvVisitorRequest.DataBind();
        }

    }

    public string GetShortDate(string dateStr)
    {
        if (dateStr != string.Empty)
        {
            return Convert.ToDateTime(dateStr).ToShortDateString();
        }
        else
            return String.Empty;
    }

    protected void lbtnDelete_Command(object sender, CommandEventArgs e)
    {
        int id = int.Parse(e.CommandArgument.ToString());
        SqlParameter[] param = new SqlParameter[] 
            {
                new SqlParameter("@strwhere", "where ID in (" + id + ")"), 
                new SqlParameter("@strTableName", "W_VisitorRequest") 
            };
        SqlHelper.DeleteByWhere("SP_DeleteByWhere", param);
        Bind();
    }
    protected void gvVisitorRequest_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this);");
        }
    }
}
