﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using VipGrade;
using System.Xml;
public partial class test_VipGrade :Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            CheckRights("User", "B1");

            Base.XMLProcess xmlDoc = new Base.XMLProcess("xml /Template.xml");
            XmlNodeList nodeList = xmlDoc.ReadAllChild("template/shop");
            foreach (XmlNode node in nodeList)
            {
                this.ShopTemplate.Items.Add(new ListItem(node.Attributes["value"].Value.ToString(), node.Attributes["value"].Value.ToString()));
            }
        }
    }



    ///**************************************************
    /// <summary>
    /// depiction：实现对会员等级的添加
    /// </summary>
    /// <param name="<参数名称>"><参数说明>
    /// </param>
    ///**************************************************
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            string strMsg = "";
            if (!Base.Common.CheckNum(this.txtServiceTime.Text.Trim()) ||!Base.Common.CheckNum(this.txtPrice.Text.Trim()))
            {
                ShowMessage("输入的服务年限或申请费用不是数字类型");
                return;
            }
            //获得等级信息
            TVipGrade TGrade = new TVipGrade();
            TGrade.Name = this.txtGradeName.Text.Trim();
            TGrade.Flag = this.ImgUrl1.Value;
            TGrade.ServiceTime = Convert.ToInt32(this.txtServiceTime.Text.Trim());
            TGrade.Price = Convert.ToInt32(this.txtPrice.Text.Trim());
            TGrade.ShopTemplate = ShopTemplate.SelectedValue.ToString();
            TGrade.Register = 1;
            //保存等级信息
            IVipGrade RVipgrade = new RVipGrade();
            int he = RVipgrade.Insert(TGrade);
            Response.Redirect("ManageVIPGrade.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage(ex.Message);
        }
    }
 
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("ManageVIPGrade.aspx");
    }
}
