﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using VipGrade;
using Base;
using System.Xml;


public partial class admin_VipGrade_EditVipGrade :Base.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("User", "B1");
        if (!IsPostBack)
        {
            bind();
        }
    }
    ///**************************************************
    /// <summary>
    /// depiction：实现对修改页面的绑定
    /// </summary>
    /// <param name="<参数名称>"><参数说明>
    /// id为请求页面得到
    /// </param>
    ///**************************************************

    private void bind()
    {
        int id = Convert.ToInt32(Request.QueryString["id"]);
        IVipGrade Vipgrade = new RVipGrade();
        DataTable dt = Vipgrade.GetDataTable(id);
        this.txtGradeName.Text = dt.Rows[0]["Name"].ToString();
        this.ImgUrl1.Value = dt.Rows[0]["Flag"].ToString();
        this.ImgUrl.Src = dt.Rows[0]["Flag"].ToString();
        this.txtServiceTime.Text = dt.Rows[0]["ServiceTime"].ToString();
        this.txtPrice.Text = dt.Rows[0]["Price"].ToString();
        //this.radlRegister.SelectedValue = dt.Rows[0]["Register"].ToString();
        //this.ShopTemplate = dt.Rows[0]["ShopTemplate"].ToString();

        Base.XMLProcess xmlDoc = new Base.XMLProcess("xml /Template.xml");
        XmlNodeList nodeList = xmlDoc.ReadAllChild("template/shop");
        foreach (XmlNode node in nodeList)
        {
            this.ShopTemplate.Items.Add(new ListItem(node.Attributes["value"].Value.ToString(), node.Attributes["value"].Value.ToString()));
            this.ShopTemplate.SelectedValue = dt.Rows[0]["ShopTemplate"].ToString();
        }
    
    }
    ///**************************************************
    /// <summary>
    /// depiction：实现修改页面
    /// </summary>
    /// <param name="<参数名称>"><参数说明>
    /// id为请求页面得到
    /// </param>
    ///**************************************************
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            if (!Base.Common.CheckNum(this.txtServiceTime.Text.Trim()) || !Base.Common.CheckNum(this.txtPrice.Text.Trim()))
            {
                ShowMessage("输入的服务年限或申请费用不是数字类型");
                return;
            }
            int id = Convert.ToInt32(Request.QueryString["id"]);
            IVipGrade Vipgrade = new RVipGrade();
            TVipGrade ur = new TVipGrade();
            ur.ID = id;
            ur.Name = this.txtGradeName.Text.Trim();
            ur.Flag = this.ImgUrl1.Value;
            ur.ServiceTime = Convert.ToInt32(this.txtServiceTime.Text.Trim());
            ur.Price = Convert.ToInt32(this.txtPrice.Text.Trim());
            ur.ShopTemplate = this.ShopTemplate.SelectedValue;
            ur.Register = 1;
            int m = Vipgrade.Update(ur);
            ShowMessage("修改成功", "VipGrade/ManageVIPGrade.aspx");
        }
        catch (Exception ex)
        {

            ShowMessage("修改失败", "VipGrade/ManageVIPGrade.aspx");
        }
      
    }
  
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Redirect("ManageVIPGrade.aspx");
    }
}
