﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using WebNews;
using Base;
using System.IO;
public partial class admin_WebNews_WebNewsEdit : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            Bind();
        }
    }

    /// <summary>
    /// 信息绑定
    /// </summary>
    private void Bind()
    {
        int id = int.Parse(Request.QueryString["ID"].ToString());
        IWebNews RWeb = new RWebNews();
        TWebNews TWeb = RWeb.GateItem(id);
        txtTitle.Text = TWeb.Title;
        dropType.SelectedValue = TWeb.Type;
        txtOrigin.Text = TWeb.Origin;
        Detail.Value = TWeb.Detail;
    }

    /// <summary>
    /// 保存
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSave_Click(object sender, EventArgs e)
    {
        try
        {
            int id = int.Parse(Request.QueryString["ID"].ToString());
            TWebNews TWeb = new TWebNews();
            TWeb.ID = id;
            TWeb.Title = txtTitle.Text;
            TWeb.Type = dropType.SelectedValue;
            TWeb.Origin = txtOrigin.Text.Trim();
            TWeb.Detail = Detail.Value;
            IWebNews RWeb = new RWebNews();
            RWeb.Update(TWeb);
            ShowMessage("修改网站动态信息成功！", "WebNews/WebNewsManage.aspx");
        }
        catch (Exception ex)
        {
            ShowMessage("修改网站动态信息失败！", "WebNews/WebNewsManage.aspx");
        }
    }

    protected void btnCancel_Click(object sender, EventArgs e)
    {
        Response.Write("<script language=javascript>window.location.href='WebNewsManage.aspx'</script>");
    }
}
