﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using WebNews;
using Base;
using System.Text;
using Product;


public partial class admin_WebNews_WebNewsManage : Base.BasePage
{
    private int pageSize = 12;//这里设置分页尺寸
    #region
    public int Pageindex
    {
        //页下标属性
        set
        {
            this.ViewState["pgindex"] = value;
        }
        get
        {
            int index = 1;
            object o = this.ViewState["pgindex"];
            if (o != null)
            {
                index = (int)o;
            }
            return index;
        }
    }
    public int PageCount
    {
        //总页数
        set { this.ViewState["pagecount"] = value; }
        get
        {
            int pagecot = 1;
            object od = this.ViewState["pagecount"];
            if (od != null)
            {
                pagecot = (int)od;
            }
            return pagecot;
        }
    }
    #endregion
    protected void Page_Load(object sender, EventArgs e)
    {
        CheckRights("Basic", "A1");
        if (!IsPostBack)
        {
            btnDelete.Attributes.Add("onclick", "javascript:return confirm('你确认要删除吗?')");
            string strUrlTo = Request.RawUrl;
            strUrlTo = strUrlTo.Substring(0, strUrlTo.IndexOf(".aspx")) + ".aspx";            
            PageNo1.Strurl = strUrlTo;
            PageNo1.PageSize = pageSize;
            PageNo1.Table = "W_WebNews";
            PageNo1.FldName = "ID";
            PageNo1.StrGetFields = "*";
            if (Request.QueryString["page"] != "" && Request.QueryString["page"] != null)
            {
                PageNo1.Pageindex = Convert.ToInt32(Request.QueryString["page"].ToString());
                if (Session["strWhere"] != null)
                {
                    PageNo1.Where = Session["strWhere"].ToString();
                }
                else
                {
                    PageNo1.Where = "1=1";
                }
                DataTable dt = PageNo1.BindViewDesc();
                if (dt.DefaultView.Count == 0)
                {
                    lblMessage.Visible = true;
                    lblMessage.Text = "暂无数据信息";
                }
                else {
                    lblMessage.Visible = false;
                }
                grdWebNews.DataSource = dt.DefaultView;
                grdWebNews.DataBind();
            }
            else {
                PageNo1.Where = "1=1";
                Session["strWhere"] = "1=1";
                PageNo1.Pageindex = 1;
                DataTable dt = PageNo1.BindViewDesc();
                if (dt.DefaultView.Count == 0)
                {
                    lblMessage.Visible = true;
                    lblMessage.Text = "暂无数据信息";
                }
                else {
                    lblMessage.Visible = false;
                }
                grdWebNews.DataSource = dt.DefaultView;
                grdWebNews.DataBind();
            }
        }
    }
    protected string GetShortDate(string datestr)
    {
        if (datestr != string.Empty)
        {
           return  Convert.ToDateTime(datestr).ToShortDateString();
        }
        else
        {
            return string.Empty;
        }
    }
    protected void btnSelect_Click(object sender, EventArgs e)
    {
        string strUrlTo1 = Request.RawUrl;
        strUrlTo1 = strUrlTo1.Substring(0, strUrlTo1.IndexOf(".aspx")) + ".aspx";
        PageNo1.Strurl = strUrlTo1;
        PageNo1.PageSize = pageSize;
        PageNo1.Table = "W_WebNews";
        PageNo1.FldName = "ID";
        PageNo1.StrGetFields = "*";

        string str = "1=1 ";
        if (txtTitle.Text.Trim() != "")
            str += " and Title like '%" +Base.GetRequest.Filter(txtTitle.Text.Trim())+ "%'";
        if (dropType.SelectedValue.ToString().Trim() != "所有类别")
            str += " and Type='" + dropType.SelectedValue.ToString().Trim() + "'";
        PageNo1.Where = str;
        Session["strWhere"] = str;
        PageNo1.Pageindex = 1;
        DataTable dt = PageNo1.BindViewDesc();
        if (dt.Rows.Count == 0)
        {
            lblMessage.Visible = true;
            lblMessage.Text = "暂无数据信息";
        }
        else
            lblMessage.Visible = false;
        grdWebNews.DataSource = dt.DefaultView;
        grdWebNews.DataBind();
    }
    protected void btnDelete_Click(object sender, EventArgs e)
    {
        for (int i = 0; i <= grdWebNews.Rows.Count - 1; i++)
        {

            CheckBox cbox = (CheckBox)grdWebNews.Rows[i].FindControl("CheckBox1");
            if (cbox.Checked == true)
            {

                int id = Convert.ToInt32(grdWebNews.DataKeys[i].Value);
                IWebNews RSystem = new RWebNews();
                int m = RSystem.Delete(id);
            }
        }
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void grdWebNews_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        grdWebNews.PageIndex = e.NewPageIndex;
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void lnkdelete_Command(object sender, CommandEventArgs e)
    {
        IWebNews RSystem = new RWebNews();
        int id = int.Parse(e.CommandArgument.ToString());
        int m = RSystem.Delete(id);
        string strURl = Request.RawUrl;
        strURl = strURl.Substring(0, strURl.IndexOf(".aspx")) + ".aspx";
        Response.Redirect(strURl + "?page=1");
        Response.End();
    }
    protected void grdWebNews_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            e.Row.Attributes.Add("onMouseOver", "SetNewColor(this);");
            e.Row.Attributes.Add("onMouseOut", "SetOldColor(this)");
        }
    }

    public string GetNewTitle(string Title, string strID)
    {
        string Restr = "<a href=\"" + Base.BasePage.Config.WebURL + "WebNews/Detail-" + strID + BasePage.Config.Rewrite+"\" target=\"blank\">" + Title + "</a>";
        return Restr;
    }
}
