﻿using System;
using System.Data;

namespace Model.Ad
{
    /// <summary>
    /// AdMemberInfo 会员信息
    /// </summary>
    public class AdMemberInfo
    {
        public AdMemberInfo() { }
        /// <summary>
        /// 实例化会员信息字段
        /// </summary>
        /// <param name="mAdrees">网站链接地址</param>
        /// <param name="mImageAdress">图片链接地址</param>
        /// <param name="mLeter">提示文字</param>
        /// <param name="mNote">简单的解释</param>
        /// <param name="mStartDate">投放开始时间</param>
        /// <param name="mDay">准备投放的天数</param>
        /// <param name="Ad_RestrictTime">广告播放情况</param>
        /// <param name="memberInfoName">广告名称</param>
        public AdMemberInfo(string mAdrees, string mImageAdress, string mLeter, string mNote, DateTime mStartDate, int mDay, int Ad_RestrictTime,string memberInfoName)
        {
            this._m_Adrees = mAdrees;
            this._m_ImageAdrees = mImageAdress;
            this._m_Leter = mLeter;
            this._m_Note = mNote;
            this._m_StartDate = mStartDate;
            this._m_Day = mDay;
            this._Ad_RestrictTime = Ad_RestrictTime;
            this._ad_MemberInfo_Name = memberInfoName;
        }
       
        private string _m_Adrees;
        private string _m_ImageAdrees;
        private string _m_Leter;
        private string _m_Note;
        private DateTime _m_StartDate;
        private int _m_Day;
        private int _Ad_RestrictTime;
        private string _ad_MemberInfo_Name;
        #region 属性
        /// <summary>
        /// 网站链接地址
        /// </summary>
        public string M_Adrees 
        {
            get { return _m_Adrees; }
            set { _m_Adrees = value; }
        }
        /// <summary>
        /// 图片链接地址
        /// </summary>
        public string MImageAdrees 
        {
            get { return _m_ImageAdrees; }
            set { _m_ImageAdrees = value; }
        }
        /// <summary>
        /// 提示文字
        /// </summary>
        public string MLeter 
        {
            get {return  _m_Leter; }
            set { _m_Leter = value; }
        }
        /// <summary>
        /// 简单的注释
        /// </summary>
        public string MNote 
        {
            get { return _m_Note; }
            set { _m_Note = value; }
        }
        /// <summary>
        /// 投放广告开始的时间
        /// </summary>
        public DateTime MStartDate 
        {
            get { return _m_StartDate; }
            set { _m_StartDate = value; }
        }
        /// <summary>
        /// 投放的广告天数
        /// </summary>
        public int MDay 
        {
            get { return _m_Day; }
            set { _m_Day = value; }
        }
        /// <summary>
        /// 广告播放情况
        /// </summary>
        public int Ad_RestrictTime 
        {
            get { return _Ad_RestrictTime; }
            set { _Ad_RestrictTime = value; }
        }
        /// <summary>
        /// 广告名称
        /// </summary>
        public string Ad_MemberInfo_Name 
        {
            get { return _ad_MemberInfo_Name; }
            set { _ad_MemberInfo_Name = value; }
        }
        #endregion
    }
}
