﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using Model.Ad;
using SqlOperate;
namespace DAL.Ad
{
    /// <summary>
    /// 广告位管理
    /// </summary>
    public class AdPlaceManage
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        /// <summary>
        /// 后台增加广告位信息
        /// </summary>
        /// <param name="adi">广告位对象</param>
        public void AdAdPlace(AdItiem adi)
        {
            SqlParameter[] parms ={ 

            new SqlParameter ("@Ad_Name", adi.Name),
            new SqlParameter ("@Ad_Type",adi.Type),
            new SqlParameter ("@Ad_Page",adi.Page),
            new SqlParameter ("@Ad_Width",adi.AdWidth),
            new SqlParameter ("@Ad_Height",adi.AdHeight),
            new SqlParameter ("@DayMoney",adi.Mark),
            new SqlParameter ("@Ad_ImageAdrees",adi.IamgeAdress),
            new SqlParameter ("@Ad_Adrees",adi.Adrees),
            };
         
            SqlHelper.ExecuteNonQuery( CommandType.StoredProcedure, "SP_W_Ad_Table_Insert", parms);
            
        }
        /// <summary>
        /// 删除一个广告位
        /// </summary>
        /// <param name="adi">所选删除的ID</param>
        public void DeleteAdInfo(int id) 
        {
            SqlParameter[] parms = { new SqlParameter("@id",id) };
            SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Ad_Table_Delte", parms);
            
        }
        /// <summary>
        /// 更新广告信息 
        /// </summary>
        /// <param name="id">广告位id</param>
        /// <param name="adi">更新的广告信息</param>
        public void UpAdInfo(int id, AdItiem adi) 
        {
            SqlParameter[] parms ={
            new SqlParameter ("@Ad_Name",adi.Name),
            new SqlParameter ("@Ad_Type",adi.Type),
            new SqlParameter ("@Ad_Page",adi.Page),
            new SqlParameter ("@Ad_Width",adi.AdWidth),
            new SqlParameter ("@Ad_Height",adi.AdHeight),
            new SqlParameter ("@DayMoney",adi.Mark),
            new SqlParameter ("@Ad_ImageAdrees",adi.IamgeAdress),
            new SqlParameter ("@Ad_Adrees",adi.Adrees),
            new SqlParameter ("@id",id)
            };

            SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure,"SP_W_Ad_Table_Update",parms);
        }
        /// <summary>
        /// 查询广告位信息
        /// </summary>
        public DataTable  SelctAdInfo(String strWhere) 
        {
            SqlParameter[] commandParameters = new SqlParameter[]{
                    new SqlParameter("@strWhere", strWhere),
            };
           
            return SqlHelper.ExecuteDataset(CommandType.StoredProcedure, "SP_W_Ad_Table_Select", commandParameters).Tables[0];
        }
        /// <summary>
        /// 查询会员申请广告信息
        /// </summary>
        /// <returns></returns>
        public DataTable SelectMemberInfo(string strWhere) 
        {
            SqlParameter[] parms ={ 
              new SqlParameter("@strWhere",strWhere)
            };
            return SqlHelper.ExecuteDataset(CommandType.StoredProcedure, "SP_W_Ad_MemberInfo_SelectMeb",parms).Tables[0];
            
        }
        /// <summary>
        /// 得到一个广告位对象实体
        /// </summary>
        /// <param name="id">广告位ID</param>
        /// <returns></returns>
        public AdItiem SelectInfo(int id) 
        {
            string str = " SELECT Ad_Name,Ad_Type,Ad_Page,Ad_Width,Ad_Height,DayMoney,Ad_ImageAdrees,Ad_Adrees FROM W_Ad_Table Where T_ID=@id";

             SqlParameter [] parms ={ 
            new SqlParameter ("@id",id)
            };

             AdItiem adi = new AdItiem();
             using (SqlDataReader reader =  SqlHelper.ExecuteReader(CommandType.Text,str,parms)) 
             {
                 if (reader.Read())
                 {
                   adi.Name=reader["Ad_Name"].ToString();
                   adi.Type = reader["Ad_Type"].ToString();
                   adi.Page = reader["Ad_Page"].ToString();
                   adi.AdWidth =Convert.ToInt32(reader["Ad_Width"].ToString());
                   adi.AdHeight =Convert.ToInt32(reader["Ad_Height"].ToString());
                   if (reader["DayMoney"].ToString() != " ") 
                   {
                       adi.Mark = Convert.ToDecimal(reader["DayMoney"].ToString());
                   }
                   adi.IamgeAdress = reader["Ad_ImageAdrees"].ToString();
                   adi.Adrees = reader["Ad_Adrees"].ToString();
                 }
                 else 
                 {
                     adi = null;
                 }
             }
             return adi;
        }
        /// <summary>
        /// 根据ID查询广告位的信息
        /// </summary>
        /// <returns></returns>
        public DataTable SelectAdPlace(int id) 
        {
            string str = " SELECT Ad_Name,Ad_Type,Ad_Page,Ad_Width,Ad_Height,DayMoney,Ad_ImageAdrees,Ad_Adrees FROM W_Ad_Table Where T_ID=@id";

            SqlParameter[] parms ={ 
            new SqlParameter ("@id",id)
            };

           return SqlHelper.ExecuteDataset(CommandType.Text, str, parms).Tables[0];
        }
        /// <summary>
        /// 发布广告更新数据方法
        /// </summary>
        /// <param name="mid">用户信息ID</param>
        /// <param name="tid">广告位ID</param>
        public void IssueAd(int mid,int tid) 
        {
            SqlParameter[] parms ={ 
            new SqlParameter ("@M_ID",mid),
            new SqlParameter ("@T_ID",tid),
            new SqlParameter ("@Ad_StartDate",DateTime.Now.ToShortTimeString())
            };
           SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure, "SP_W_Ad_MemberInfo_RestrictTime", parms);
        }
        /// <summary>
        /// 删除会员信息
        /// </summary>
        /// <param name="mid">会员申请信息的ID</param>
        public void DeletMemberAdInfo(int mid) 
        {
            string str = "delete from W_Ad_MemberInfo where M_ID=@mid";
            SqlParameter[] parms ={
            new SqlParameter ("@mid",mid)
            };
            SqlHelper.ExecuteNonQuery(CommandType.Text, str, parms);
        }
    }
}
