﻿using System;
using System.Data;
using System.Configuration;
using System.Data.SqlClient;
using Model.Ad;
using SqlOperate;

namespace DAL.Ad
{
    /// <summary>
    /// MemberInfo 会员提供信息类
    /// </summary>
    public class MemberInfo
    {
        public static string ConnectionString = ConfigurationManager.ConnectionStrings["sqlData"].ConnectionString;
        #region
        public MemberInfo(){}
        /// <summary>
        /// 会员添加广告信息
        /// </summary>
        /// <param name="t_id">广告位ID</param>
        /// <param name="userid">用户ID</param>
        /// <param name="UMName">申请广告人的名称（即会员或者管理员）</param>
        /// <param name="IsUM">标志管理员和会员</param>
        /// <param name="adi"></param>
        public void AddMemberAdInfo(int t_id,int userid,string IsUM,string UMName,AdMemberInfo adm) 
        {
            SqlParameter[] parms ={
            new SqlParameter ("@User_ID",userid),
            new SqlParameter ("@T_ID",t_id),
            new SqlParameter ("@Ad_Adrees",adm.M_Adrees),
            new SqlParameter ("@Ad_Leter",adm.MLeter),
            new SqlParameter ("@Ad_ImageAdrees",adm.MImageAdrees),
            new SqlParameter ("@Ad_Day",adm.MDay),
            new SqlParameter ("@MemberInfoName",adm.Ad_MemberInfo_Name),
            new SqlParameter ("@Ad_StartDate",DateTime.Now.ToShortTimeString()),
            new SqlParameter ("@UM_Name",UMName),
            new SqlParameter("@UM_Sign",IsUM)
            };
      
            SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure,"SP_W_Ad_MemberInfo_Insert", parms);
        }
        /// <summary>
        /// 会员更新广告信息
        /// </summary>
        /// <param name="upid">会员更新的数据id</param>
        /// <param name="adm">会员对象</param>
        public void UpdateMemberAdInfo(int upid,AdMemberInfo adm) 
        {
            SqlParameter[] parms ={ 
            new SqlParameter ("@Ad_Adrees",adm.M_Adrees),
            new SqlParameter ("@Ad_Leter",adm.MLeter),
            new SqlParameter ("@Ad_ImageAdrees",adm.MImageAdrees),
            new SqlParameter ("@Ad_Day",adm.MDay),
            new SqlParameter ("@upid",upid),
            new SqlParameter ("@MemberInfoName",adm.Ad_MemberInfo_Name),
            new SqlParameter ("@Ad_StartDate",DateTime.Now.ToShortDateString())
            };

            SqlHelper.ExecuteNonQuery(CommandType.StoredProcedure,"SP_W_Ad_MemberInfo_Update", parms);
        }
        /// <summary>
        /// 根据用户ID查询信息
        /// </summary>
        /// <param name="userid">用户ID</param>
        /// <returns>返回列表</returns>
        public DataTable SelectMemberAdInfo(int userid) 
        {
            SqlParameter[] parms ={ 
            new SqlParameter ("@userid",userid)
            };
            return SqlHelper.ExecuteDataset(CommandType.StoredProcedure, "SP_W_Ad_MemberInfo_Select",parms).Tables[0];
        }
        
        /// <summary>
        /// 审核广告方法
        /// </summary>
        public void ShenHe(int mid,string str)
        {
            string senhe = "通过";
            string update = "update W_Ad_MemberInfo set Ad_Auditing=@senhe where M_ID=@mid";
            SqlParameter[] parms ={ 
            new SqlParameter ("@mid",mid),
            new SqlParameter ("@senhe",str)
            };
            SqlHelper.ExecuteNonQuery(CommandType.Text, update, parms);
        }
        /// <summary>
        /// 返回会员申请的信息信息实体
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public AdMemberInfo GetModelMemberAdInfo(string strWhere) 
        {
              string str = "select Ad_Adrees,Ad_ImageAdrees,M_ID,Ad_Leter,Ad_Day,Ad_MemberInfoName from W_Ad_MemberInfo "+strWhere;
            AdMemberInfo adm = new AdMemberInfo();
            using (SqlDataReader read = SqlHelper.ExecuteReader(CommandType.Text, str,null)) 
            {
                if (read.Read())
                {
                    adm.M_Adrees = read["Ad_Adrees"].ToString();
                    adm.MImageAdrees = read["Ad_ImageAdrees"].ToString();
                    adm.MDay = Convert.ToInt32(read["Ad_Day"].ToString());
                    adm.Ad_MemberInfo_Name = read["Ad_MemberInfoName"].ToString();
                    if (read["Ad_Leter"].ToString() != "")
                    {
                        adm.MLeter = read["Ad_Leter"].ToString();
                    }
                }
                else
                {
                    adm = null;
                }
            }
            return adm;
        }
        #endregion
    }
       
}